/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.directindex.api;

import com.google.gson.Gson;
import eu.dnetlib.common.rmi.DNetRestDocumentation;
import eu.dnetlib.data.index.CloudIndexClientException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.index.solr.feed.StreamingInputDocumentFactory;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.openaire.directindex.api.DirecIndexApiException;
import eu.dnetlib.openaire.directindex.api.IndexClientManager;
import eu.dnetlib.openaire.directindex.api.IndexDSRetriever;
import eu.dnetlib.openaire.directindex.api.IndexDsInfo;
import eu.dnetlib.openaire.directindex.api.RecentResultsQueue;
import eu.dnetlib.openaire.directindex.api.ResultSubmitterService;
import eu.dnetlib.openaire.directindex.objects.ResultEntry;
import eu.dnetlib.openaire.directindex.objects.ResultEntryToOaf;
import eu.dnetlib.openaire.directindex.utils.OafToIndexRecordFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.common.SolrInputDocument;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@DNetRestDocumentation
public class OpenaireResultSubmitter {
    private static final Log log = LogFactory.getLog(OpenaireResultSubmitter.class);
    @Value(value="${openaire.api.community}")
    private String community_api;
    @Value(value="oaf.schema.location")
    private String oafSchemaLocation;
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Resource
    private OafToIndexRecordFactory oafToIndexRecordFactory;
    @Resource
    private RecentResultsQueue recentResultsQueue;
    @Resource(name="openaireplusApisVelocityEngine")
    private VelocityEngine velocityEngine;
    @Resource(name="indexClientManager")
    private IndexClientManager clientManager;
    @Resource(name="resultSubmitterService")
    private ResultSubmitterService submitterService;
    @Autowired
    private IndexDSRetriever indexDSRetriever;

    @RequestMapping(value={"/api/admin/autocommit/active"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean getAutocommit() throws DirecIndexApiException {
        return this.submitterService.isAutocommitactive();
    }

    @RequestMapping(value={"/api/admin/autocommit/active"}, method={RequestMethod.POST})
    @ResponseBody
    public Boolean setAutocommit(@RequestParam(value="active", required=true) Boolean active) throws DirecIndexApiException {
        this.submitterService.setAutocommitactive(active);
        log.info((Object)String.format("automatic commit, active '%s', frequency '%s'", this.submitterService.isAutocommitactive(), this.submitterService.getCommitfrquency()));
        return this.submitterService.isAutocommitactive();
    }

    @RequestMapping(value={"/api/admin/evictCache"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public void evictCache() {
        this.indexDSRetriever.evictCache();
    }

    @Deprecated
    @RequestMapping(value={"/api/publications/feedJson", "/api/results/feedJson"}, method={RequestMethod.POST})
    @ResponseBody
    public String feedObjectJson(@RequestParam(value="json", required=true) String json, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws DirecIndexApiException {
        log.debug((Object)json);
        ResultEntry pub = (ResultEntry)new Gson().fromJson(json, ResultEntry.class);
        return this.feedObject(pub, commit);
    }

    @RequestMapping(value={"/api/results/feedObject"}, method={RequestMethod.POST})
    @ResponseBody
    public String feedResult(@RequestBody ResultEntry pub, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws DirecIndexApiException {
        return this.feed(pub, commit);
    }

    @Deprecated
    @RequestMapping(value={"/api/publications/feedObject"}, method={RequestMethod.POST})
    @ResponseBody
    public String feedObject(@RequestBody ResultEntry pub, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws DirecIndexApiException {
        return this.feed(pub, commit);
    }

    @RequestMapping(value={"/api/result/{openaireId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean deleteResultWithOpenaireId(@PathVariable(value="openaireId") String openaireId, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws DirecIndexApiException {
        return this.deleteResult(openaireId);
    }

    @RequestMapping(value={"/api/results"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean deleteResultWithOriginalId(@RequestParam(value="originalId", required=true) String originalId, @RequestParam(value="collectedFromId", required=true) String collectedFromId, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws Exception {
        String openaireId = ResultEntryToOaf.calculateOpenaireId(originalId, collectedFromId, (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class));
        return this.deleteResult(openaireId);
    }

    @Deprecated
    @RequestMapping(value={"/api/publications/deleteObject", "/api/results/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean deleteResultPost(@RequestParam(value="originalId", required=true) String originalId, @RequestParam(value="collectedFromId", required=true) String collectedFromId, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws Exception {
        String openaireId = ResultEntryToOaf.calculateOpenaireId(originalId, collectedFromId, (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class));
        return this.deleteResult(openaireId);
    }

    @Deprecated
    private String feed(ResultEntry pub, boolean commit) throws DirecIndexApiException {
        return this.feed(pub);
    }

    private String feed(ResultEntry pub) throws DirecIndexApiException {
        log.debug((Object)pub);
        try {
            ResultEntryToOaf toOaf = new ResultEntryToOaf(this.community_api);
            IndexDsInfo info = this.indexDSRetriever.calculateCurrentIndexDsInfo();
            String oafRecord = toOaf.asOafRecord(pub, this.velocityEngine, (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class), this.oafSchemaLocation);
            SolrInputDocument solrDocument = this.prepareSolrDocument(oafRecord, info.getIndexDsId(), (UnaryFunction<String, String>)this.oafToIndexRecordFactory.newTransformer(info.getFormat()));
            this.clientManager.getClient(info).add(solrDocument);
            this.recentResultsQueue.add(oafRecord);
            return pub.getOpenaireId();
        }
        catch (Throwable e) {
            log.error((Object)"Error saving record", e);
            log.debug((Object)pub.toString());
            throw new DirecIndexApiException("Error adding publication: " + e.getMessage(), e);
        }
    }

    private SolrInputDocument prepareSolrDocument(String record, String indexDsId, UnaryFunction<String, String> toIndexRecord) throws CloudIndexClientException {
        try {
            StreamingInputDocumentFactory documentFactory = new StreamingInputDocumentFactory();
            String version = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'").format(new Date());
            String indexRecord = (String)toIndexRecord.evaluate((Object)record);
            if (log.isDebugEnabled()) {
                log.debug((Object)("***************************************\nSubmitting index record:\n" + indexRecord + "\n***************************************\n"));
            }
            return documentFactory.parseDocument(version, indexRecord, indexDsId, "dnetResult");
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error creating solr document", e);
        }
    }

    private boolean deleteResult(String openaireId) throws DirecIndexApiException {
        try {
            IndexDsInfo info = this.indexDSRetriever.calculateCurrentIndexDsInfo();
            String query = String.format("objidentifier:\"%s\" OR resultdupid:\"%s\"", openaireId, openaireId);
            CloudSolrClient client = this.clientManager.getClient(info);
            client.deleteByQuery(info.getColl(), query);
            log.info((Object)("Deleted result with id: " + openaireId + " from: " + info.getIndexBaseUrl()));
            this.recentResultsQueue.remove(openaireId);
            return true;
        }
        catch (Throwable e) {
            throw new DirecIndexApiException("Error deleting publication: " + e.getMessage(), e);
        }
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessage handleException(Exception e) {
        log.error((Object)"Error in direct index API", (Throwable)e);
        return new ErrorMessage(e);
    }

    public class ErrorMessage {
        private final String message;
        private final String stacktrace;

        public ErrorMessage(Exception e) {
            this(e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
        }

        public ErrorMessage(String message, String stacktrace) {
            this.message = message;
            this.stacktrace = stacktrace;
        }

        public String getMessage() {
            return this.message;
        }

        public String getStacktrace() {
            return this.stacktrace;
        }
    }
}

