/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.directindex.api;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.openaire.directindex.api.IndexDsInfo;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.core.io.ClassPathResource;

public class IndexDSRetriever {
    private static final Log log = LogFactory.getLog(IndexDSRetriever.class);
    @Value(value="${openaire.api.directindex.findSolrIndexUrl.xquery}")
    private ClassPathResource findSolrIndexUrl;
    @Value(value="${openaire.api.directindex.findIndexDsInfo.xquery}")
    private ClassPathResource findIndexDsInfo;
    @Resource
    private UniqueServiceLocator serviceLocator;

    @Cacheable(value={"indexDsInfo"})
    public IndexDsInfo calculateCurrentIndexDsInfo() throws IOException, ISLookUpException {
        log.info((Object)"Not using cache");
        String queryUrl = IOUtils.toString((InputStream)this.findSolrIndexUrl.getInputStream());
        String queryDs = IOUtils.toString((InputStream)this.findIndexDsInfo.getInputStream());
        ISLookUpService lu = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        String indexBaseUrl = lu.getResourceProfileByQuery(queryUrl);
        String idxDs = lu.getResourceProfileByQuery(queryDs);
        if (idxDs.isEmpty()) {
            throw new IllegalStateException(queryDs + "\n\nreturned no results, check IS profiles");
        }
        String[] arr = idxDs.split("@@@");
        return new IndexDsInfo(indexBaseUrl, arr[0].trim(), arr[1].trim(), arr[2].trim());
    }

    @CacheEvict(value={"indexDsInfo"}, allEntries=true)
    public void evictCache() {
        log.info((Object)"Evicting indexDsInfo cache");
    }
}

