/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.directindex.objects;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import eu.dnetlib.miscutils.functional.string.EscapeXml;
import eu.dnetlib.openaire.directindex.api.DirecIndexApiException;
import eu.dnetlib.openaire.directindex.api.OpenAIRESubmitterUtils;
import eu.dnetlib.openaire.directindex.objects.DatasourceEntry;
import eu.dnetlib.openaire.directindex.objects.ResultEntry;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.ui.velocity.VelocityEngineUtils;

public class ResultEntryToOaf {
    private static final Log log = LogFactory.getLog(ResultEntryToOaf.class);
    private static long last_cache_update = 0L;
    private static final Map<String, Map<String, String>> cached_vocabularies = new HashMap<String, Map<String, String>>();
    private static final Map<String, DatasourceEntry> cached_datasources = new HashMap<String, DatasourceEntry>();
    private static final Map<String, String> cached_contexts = new HashMap<String, String>();
    private OpenAIRESubmitterUtils utils;

    public ResultEntryToOaf(String community_api) {
        this.utils = new OpenAIRESubmitterUtils(community_api);
    }

    public String asOafRecord(ResultEntry entry, VelocityEngine ve, ISLookUpService lookupService, String oafSchemaLocation) throws Exception {
        if (StringUtils.isBlank((String)entry.getOriginalId()) && StringUtils.isBlank((String)entry.getOpenaireId())) {
            throw new DirecIndexApiException("One of the following fields is required: originalId or openaireId");
        }
        if (StringUtils.isBlank((String)entry.getTitle())) {
            throw new DirecIndexApiException("A required field is missing: title");
        }
        if (StringUtils.isBlank((String)entry.getUrl())) {
            throw new DirecIndexApiException("A required field is missing: url");
        }
        if (StringUtils.isBlank((String)entry.getLicenseCode()) && StringUtils.isBlank((String)entry.getAccessRightCode())) {
            throw new DirecIndexApiException("A required field is missing: accessRightCode");
        }
        if (StringUtils.isBlank((String)entry.getResourceType())) {
            throw new DirecIndexApiException("A required field is missing: resourceType");
        }
        if (StringUtils.isBlank((String)entry.getCollectedFromId())) {
            throw new DirecIndexApiException("A required field is missing: collectedFromId");
        }
        if (StringUtils.isBlank((String)entry.getType())) {
            throw new DirecIndexApiException("A required field is missing: type");
        }
        DatasourceEntry collectedFromEntry = ResultEntryToOaf.getDatasourceInfo(entry.getCollectedFromId(), lookupService);
        DatasourceEntry hostedByEntry = ResultEntryToOaf.getDatasourceInfo(entry.getHostedById(), lookupService);
        if (StringUtils.isBlank((String)entry.getOpenaireId())) {
            entry.setOpenaireId(ResultEntryToOaf.calculateOpenaireId(entry.getOriginalId(), collectedFromEntry));
        }
        if (!entry.getOpenaireId().matches("^\\w{12}::\\w{32}$")) {
            throw new DirecIndexApiException("Invalid openaireId: " + entry.getOpenaireId() + " - regex ^\\w{12}::\\w{32}$ not matched");
        }
        List<OpenAIRESubmitterUtils.ContextInfo> contextInfos = this.utils.processContexts(entry.getContexts(), ResultEntryToOaf.getContexts(lookupService));
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("esc", new EscapeXml());
        model.put("util", this.utils);
        model.put("pub", this);
        model.put("objIdentifier", entry.getOpenaireId());
        model.put("oafSchemaLocation", oafSchemaLocation);
        model.put("resultTypes", ResultEntryToOaf.getVocabulary("dnet:result_typologies", lookupService));
        model.put("rights", ResultEntryToOaf.getVocabulary("dnet:access_modes", lookupService));
        model.put("resourceTypes", ResultEntryToOaf.getVocabulary("dnet:publication_resource", lookupService));
        model.put("pidTypes", ResultEntryToOaf.getVocabulary("dnet:pid_types", lookupService));
        model.put("languages", ResultEntryToOaf.getVocabulary("dnet:languages", lookupService));
        model.put("contexts", ResultEntryToOaf.getContexts(lookupService));
        model.put("contextInfo", contextInfos);
        model.put("dateOfCollection", new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'").format(new Date()));
        model.put("collectedFrom", collectedFromEntry);
        model.put("hostedBy", hostedByEntry);
        return VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)ve, (String)"/eu/dnetlib/openaire/directindex/indexRecord.xml.vm", (String)"UTF-8", model);
    }

    private static synchronized DatasourceEntry getDatasourceInfo(String dsId, ISLookUpService lookupService) throws ISLookUpException {
        if (StringUtils.isBlank((String)dsId)) {
            return new DatasourceEntry("openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18", "Unknown Repository", "unknown_____");
        }
        if (!cached_datasources.containsKey(dsId)) {
            String query = "collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')//CONFIGURATION[./DATASOURCE_ORIGINAL_ID='" + dsId + "']/concat(./OFFICIAL_NAME, ' @@@ ', .//FIELD/value[../key='NamespacePrefix'])";
            String s = lookupService.getResourceProfileByQuery(query);
            String[] arr = s.split("@@@");
            DatasourceEntry ds = new DatasourceEntry(dsId, arr[0].trim(), arr[1].trim());
            if (StringUtils.isBlank((String)ds.getName()) || StringUtils.isBlank((String)ds.getPrefix())) {
                log.error((Object)("Invalid datasource id: " + dsId));
                throw new ISLookUpException("Invalid datasource id: " + dsId);
            }
            cached_datasources.put(dsId, ds);
        }
        return cached_datasources.get(dsId);
    }

    private static synchronized Map<String, String> getVocabulary(String voc, ISLookUpService lookupService) throws ISLookUpException {
        if (DateUtils.now() - last_cache_update < TimeUnit.MINUTES.toMillis(15L) && cached_vocabularies.containsKey(voc)) {
            return cached_vocabularies.get(voc);
        }
        String query = "collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')[.//VOCABULARY_NAME/@code='" + voc + "']//TERM/concat(@code, ' @@@ ', @english_name)";
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : lookupService.quickSearchProfile(query)) {
            String[] arr = s.split("@@@");
            map.put(arr[0].trim(), arr[1].trim());
        }
        cached_vocabularies.put(voc, map);
        last_cache_update = DateUtils.now();
        return map;
    }

    private static synchronized Map<String, String> getContexts(ISLookUpService lookupService) throws ISLookUpException {
        if (DateUtils.now() - last_cache_update > TimeUnit.MINUTES.toMillis(15L) || cached_contexts.isEmpty()) {
            String query = "collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')[.//context/@type='community' or .//context/@type='ri']//*[name()='context' or name()='category' or name()='concept']/concat(@id, ' @@@ ', @label)";
            cached_contexts.clear();
            for (String s : lookupService.quickSearchProfile("collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')[.//context/@type='community' or .//context/@type='ri']//*[name()='context' or name()='category' or name()='concept']/concat(@id, ' @@@ ', @label)")) {
                String[] arr = s.split("@@@");
                cached_contexts.put(arr[0].trim(), arr[1].trim());
            }
            last_cache_update = DateUtils.now();
        }
        return cached_contexts;
    }

    private static String calculateOpenaireId(String originalId, DatasourceEntry collectedFromEntry) {
        return collectedFromEntry.getPrefix() + "::" + Hashing.md5((String)originalId);
    }

    public static String calculateOpenaireId(String originalId, String collectedFromId, ISLookUpService lookupService) throws ISLookUpException {
        return ResultEntryToOaf.calculateOpenaireId(originalId, ResultEntryToOaf.getDatasourceInfo(collectedFromId, lookupService));
    }

    public OpenAIRESubmitterUtils getUtils() {
        return this.utils;
    }

    public void setUtils(OpenAIRESubmitterUtils utils) {
        this.utils = utils;
    }
}

