/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.directindex.api;

import eu.dnetlib.functionality.index.utils.ZkServers;
import eu.dnetlib.openaire.directindex.api.IndexDsInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.impl.CloudSolrClient;

public class IndexClientManager {
    private static final Log log = LogFactory.getLog(IndexClientManager.class);
    private CloudSolrClient client = null;

    public CloudSolrClient getClient(IndexDsInfo info) {
        if (this.client == null) {
            log.info((Object)String.format("Initializing solr client (%s) with collection %s", info.getIndexBaseUrl(), info.getColl()));
            ZkServers zk = ZkServers.newInstance((String)info.getIndexBaseUrl());
            CloudSolrClient.Builder builder = new CloudSolrClient.Builder(zk.getHosts(), zk.getChroot()).withParallelUpdates(true);
            this.client = builder.build();
        }
        this.client.setDefaultCollection(info.getColl());
        return this.client;
    }
}

