package eu.dnetlib.openaire.directindex.utils;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.annotation.Resource;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.ClassPathResource;

/**
 * Created by michele on 15/12/15.
 */
public class OafToIndexRecordFactory {

	private ClassPathResource layoutToRecord;

	@Resource
	private UniqueServiceLocator serviceLocator;

	public ApplyXslt newTransformer(final String format) throws ISLookUpException, IOException, TransformerException {
		final TransformerFactory factory = TransformerFactory.newInstance();
		final Transformer layoutTransformer = factory.newTransformer(readLayoutToRecord());

		final StreamResult layoutToXsltXslt = new StreamResult(new StringWriter());

		layoutTransformer.setParameter("format", format);
		layoutTransformer.transform(new StreamSource(new StringReader(getLayoutSource(format))), layoutToXsltXslt);

		return new ApplyXslt(layoutToXsltXslt.getWriter().toString());
	}

	private StreamSource readLayoutToRecord() throws IOException {
		return new StreamSource(new StringReader(IOUtils.toString(layoutToRecord.getInputStream())));
	}

	private String getLayoutSource(final String format) throws ISLookUpDocumentNotFoundException, ISLookUpException {
		return serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(
				"collection('/db/DRIVER/MDFormatDSResources/MDFormatDSResourceType')[.//NAME='" + format + "']//LAYOUT[@name='index']");
	}

	public ClassPathResource getLayoutToRecord() {
		return layoutToRecord;
	}

	@Required
	public void setLayoutToRecord(final ClassPathResource layoutToRecord) {
		this.layoutToRecord = layoutToRecord;
	}

}
