/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.directindex.api;

import eu.dnetlib.openaire.directindex.api.IndexClientManager;
import eu.dnetlib.openaire.directindex.api.IndexDSRetriever;
import eu.dnetlib.openaire.directindex.api.IndexDsInfo;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ResultSubmitterService {
    private static final Log log = LogFactory.getLog(ResultSubmitterService.class);
    @Autowired
    private IndexDSRetriever indexDSRetriever;
    @Resource(name="indexClientManager")
    private IndexClientManager clientManager;
    @Value(value="${openaire.api.directindex.autocommit.active}")
    private boolean autocommitactive;
    @Value(value="${openaire.api.directindex.autocommit.frequency}")
    private long commitfrquency = 60L;
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public ResultSubmitterService() {
        this.updateCommitSchedule();
    }

    private void updateCommitSchedule() {
        log.info((Object)"updating commit schedule");
        this.executor.scheduleAtFixedRate(() -> {
            if (this.isAutocommitactive()) {
                try {
                    IndexDsInfo info = this.indexDSRetriever.calculateCurrentIndexDsInfo();
                    CloudSolrClient client = this.clientManager.getClient(info);
                    log.info((Object)("performing commit on " + info.getColl()));
                    client.commit();
                }
                catch (Throwable e) {
                    log.error((Object)"unable to perform commit", e);
                }
            }
        }, 0L, this.getCommitfrquency(), TimeUnit.SECONDS);
    }

    public boolean isAutocommitactive() {
        return this.autocommitactive;
    }

    public synchronized void setAutocommitactive(boolean autocommitactive) {
        this.autocommitactive = autocommitactive;
    }

    public long getCommitfrquency() {
        return this.commitfrquency;
    }

    public synchronized void setCommitfrquency(long commitfrquency) {
        this.commitfrquency = commitfrquency;
    }
}

