package eu.dnetlib.openaire.directindex.objects;

import com.google.gson.Gson;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import eu.dnetlib.miscutils.functional.string.EscapeXml;
import eu.dnetlib.openaire.directindex.api.DirecIndexApiException;
import eu.dnetlib.openaire.directindex.api.OpenAIRESubmitterUtils;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.ui.velocity.VelocityEngineUtils;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * Created by michele on 02/12/15.
 */
public class ResultEntry {


	private String openaireId;
	private String originalId;
	private String title;
	private List<String> authors = new ArrayList<>();
	private String publisher;
	private String description;
	private String language;
	private List<PidEntry> pids = new ArrayList<>();
	/**
	 * @Deprecated: use accessRightCode
	 */
	@Deprecated
	private String licenseCode;
	private String accessRightCode;
	private String embargoEndDate;
	/**
	 * One of publication, dataset, software, other. Default value is publication.
	 */
	private String type = "publication";
	private String resourceType;
	private String url;
	private String collectedFromId;
	private String hostedById;

	// String according to the EGI context profile, example: egi::classification::natsc::math
	private List<String> contexts = new ArrayList<>();

	// String according to openaire guidelines:
	// info:eu-repo/grantAgreement/Funder/FundingProgram/ProjectID/[Jurisdiction]/[ProjectName]/[ProjectAcronym]
	private List<String> linksToProjects = new ArrayList<>();

	private static final Log log = LogFactory.getLog(ResultEntry.class);

	public ResultEntry() {}

	public String getOpenaireId() {
		return openaireId;
	}

	public void setOpenaireId(final String openaireId) {
		this.openaireId = openaireId;
	}

	public String getOriginalId() {
		return originalId;
	}

	public void setOriginalId(final String originalId) {
		this.originalId = originalId;
	}

	@ApiModelProperty(required = true)
	public String getTitle() {
		return title;
	}

	public void setTitle(final String title) {
		this.title = title;
	}

	public List<String> getAuthors() {
		return authors;
	}

	public void setAuthors(final List<String> authors) {
		this.authors = authors;
	}

	public String getPublisher() {
		return publisher;
	}

	public void setPublisher(final String publisher) {
		this.publisher = publisher;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(final String description) {
		this.description = description;
	}

	@ApiModelProperty(value = "ISO Alpha-3 code. E.g. 'eng', 'ita'")
	public String getLanguage() {
		return language;
	}

	public void setLanguage(final String language) {
		this.language = language;
	}

	public List<PidEntry> getPids() {
		return pids;
	}

	public void setPids(final List<PidEntry> pids) {
		this.pids = pids;
	}

	@Deprecated
	@ApiModelProperty(required = false, allowableValues = "OPEN, CLOSED, RESTRICTED, EMBARGO, UNKNOWN, OTHER, OPEN SOURCE")
	public String getLicenseCode() {
		return licenseCode;
	}
	@Deprecated
	public void setLicenseCode(final String licenseCode) {
		this.licenseCode = licenseCode;
	}

	/**
	 * Set required = true when the deprecated licenseCode is not used anymore by our client and it is removed
	 * @return access rights code
	 */
	@ApiModelProperty(required = false, allowableValues = "OPEN, CLOSED, RESTRICTED, EMBARGO, UNKNOWN, OTHER, OPEN SOURCE")
	public String getAccessRightCode() {
		return accessRightCode;
	}

	public void setAccessRightCode(final String accessRightCode) {
		this.accessRightCode = accessRightCode;
	}

	@ApiModelProperty(required = true, value = "Use 001 for articles, 021 for datasets, 0029 for software. See: http://api.openaire.eu/vocabularies/dnet:publication_resource for all the available resource types.")
	public String getResourceType() {
		return resourceType;
	}

	public void setResourceType(final String resourceType) {
		this.resourceType = resourceType;
	}

	@ApiModelProperty(required = true)
	public String getUrl() {
		return url;
	}

	public void setUrl(final String url) {
		this.url = url;
	}

	@ApiModelProperty(required = true, value = "Use opendoar___::2659 for Zenodo Publications; re3data_____::r3d100010468 for Zenodo datasets; infrastruct::openaire for OpenAIRE portal.")
	public String getCollectedFromId() {
		return collectedFromId;
	}

	public void setCollectedFromId(final String collectedFromId) {
		this.collectedFromId = collectedFromId;
	}

	public String getHostedById() {
		return hostedById;
	}

	public void setHostedById(final String hostedById) {
		this.hostedById = hostedById;
	}

	@ApiModelProperty(value = "E.g. fet, egi::classification::natsc::math::pure, egi::projects::EMI")
	public List<String> getContexts() {
		return contexts;
	}

	public void setContexts(final List<String> contexts) {
		this.contexts = contexts;
	}

	@ApiModelProperty(value = "E.g. info:eu-repo/grantAgreement/EC/FP7/283595/EU//OpenAIREplus")
	public List<String> getLinksToProjects() {
		return linksToProjects;
	}

	public void setLinksToProjects(final List<String> linksToProjects) {
		this.linksToProjects = linksToProjects;
	}

	@ApiModelProperty(allowableValues = "publication, dataset, software, other")
	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public String getEmbargoEndDate() {
		return embargoEndDate;
	}

	public void setEmbargoEndDate(final String embargoEndDate) {
		this.embargoEndDate = embargoEndDate;
	}

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}

	public String getAnyId() {
		return StringUtils.isNotBlank(openaireId) ? openaireId : originalId;
	}
}
