package eu.dnetlib.download.plugin;

import java.util.ArrayList;
import java.util.List;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.AbstractDownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadPluginException;

/**
 * The Class EasyPDFDownloadPlugin.
 */
public class EasyPDFDownloadPlugin extends AbstractDownloadPlugin implements DownloadPlugin {

    /*
     * (non-Javadoc)
     *
     * @see eu.dnetlib.data.download.rmi.DownloadPlugin#retrieveUrl(eu.dnetlib.data.download.rmi.DownloadItem)
     */
    @Override
    public DownloadItem retrieveUrl(final DownloadItem input) {
        if (checkOpenAccess(input) == null) {
            return null;
        }
        if (input == null) {
            return null;
        }
        String url = input.getOriginalUrl();

        if (url == null || url.trim().length() == 0) {
            return input;
        }
        @SuppressWarnings("unchecked")
        List<String> urls = new Gson().fromJson(url, ArrayList.class);
        if (urls == null || urls.size() == 0) {
            return input;
        }
        if (checkUrlsNotNull(input, urls))
            return input;
        input.setOriginalUrl(null);
        input.setUrl(null);
        return input;
    }

    @Override
    public Iterable<DownloadItem> retrieveUrls(final Iterable<DownloadItem> urls) {
        return Iterables.transform(urls, new Function<DownloadItem, DownloadItem>() {

            @Override
            public DownloadItem apply(final DownloadItem input) {
                return retrieveUrl(input);
            }
        });
    }

    /*
     * (non-Javadoc)
     *
     * @see eu.dnetlib.data.download.rmi.DownloadPlugin#getPluginName()
     */
    @Override
    public String getPluginName() {
        return "easyPDFDownloadPlugin";
    }

    @Override
    public void setBasePath(final String basePath) {
        // TODO Auto-generated method stub

    }

    @Override
    public String extractURL(String baseURL) throws DownloadPluginException {
        return baseURL.endsWith(".pdf") ? baseURL : null;
    }
}
