/**
 *
 */
package eu.dnetlib.download.plugin;


import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPluginException;

/**
 * The Class EasyPDFDownloadPlugin.
 */
public class DLibPlugin extends HALPdfDocumentPlugin {


    @Override
    public Iterable<DownloadItem> retrieveUrls(final Iterable<DownloadItem> urls) {
        return Iterables.transform(urls, new Function<DownloadItem, DownloadItem>() {

            @Override
            public DownloadItem apply(final DownloadItem input) {
                return retrieveUrl(input);
            }
        });
    }

    /*
     * (non-Javadoc)
     *
     * @see eu.dnetlib.data.download.rmi.DownloadPlugin#getPluginName()
     */
    @Override
    public String getPluginName() {
        return "DLIBDownloadPlugin";
    }

    @Override
    public void setBasePath(final String basePath) {
        // TODO Auto-generated method stub

    }

    @Override
    public String extractURL(String baseURL) throws DownloadPluginException {
        return baseURL.trim().endsWith(".html") ? baseURL : null;
    }
}
