/**
 *
 */
package eu.dnetlib.download.plugin;

import java.util.ArrayList;
import java.util.List;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.AbstractDownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadPluginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * @author sandro
 */
public class HALPdfDocumentPlugin extends AbstractDownloadPlugin implements DownloadPlugin {

    private static final Log log = LogFactory.getLog(HALPdfDocumentPlugin.class); // NOPMD by marko on 11/24/08 5:02 PM


    /**
     * {@inheritDoc}
     *
     * @see eu.dnetlib.data.download.rmi.DownloadPlugin#getPluginName()
     */
    @Override
    public String getPluginName() {
        // TODO Auto-generated method stub
        return "HALPdfDocumentPlugin";
    }

    /**
     * {@inheritDoc}
     *
     * @see eu.dnetlib.data.download.rmi.DownloadPlugin#retrieveUrls(java.lang.Iterable)
     */
    @Override
    public Iterable<DownloadItem> retrieveUrls(final Iterable<DownloadItem> urls) {
        return Iterables.transform(urls, new Function<DownloadItem, DownloadItem>() {

            @Override
            public DownloadItem apply(final DownloadItem input) {
                return retrieveUrl(input);
            }
        });
    }

    /**
     * {@inheritDoc}
     *
     * @see eu.dnetlib.data.download.rmi.DownloadPlugin#retrieveUrl(eu.dnetlib.data.download.rmi.DownloadItem)
     */
    @Override
    public DownloadItem retrieveUrl(final DownloadItem input) {
        try {
            if (checkOpenAccess(input) == null) return null;
            if (input == null) return null;
            String url = input.getOriginalUrl();

            if ((url == null) || (url.trim().length() == 0)) return input;
            @SuppressWarnings("unchecked")
            List<String> urls = new Gson().fromJson(url, ArrayList.class);
            if ((urls == null) || (urls.size() == 0)) return input;
            if (checkUrlsNotNull(input, urls)) return input;
            input.setOriginalUrl(null);
            input.setUrl(null);
            return input;
        } catch (Throwable e) {
            log.error("Error on retreiving URL", e);
            input.setOriginalUrl(null);
            input.setUrl(null);
            return input;
        }
    }

    /**
     * {@inheritDoc}
     *
     * @see eu.dnetlib.data.download.rmi.DownloadPlugin#setBasePath(java.lang.String)
     */
    @Override
    public void setBasePath(final String arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public String extractURL(String baseURL) throws DownloadPluginException {
        return baseURL.toLowerCase().endsWith("document") ? baseURL : null;
    }
}
