package eu.dnetlib.download.plugin;

import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.AbstractDownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadPluginException;

/**
 * Created by sandro on 3/1/16.
 */
public class HindawiDownloadPlugin extends AbstractDownloadPlugin implements DownloadPlugin {

	private String basePath;

	private Gson gson;

	public HindawiDownloadPlugin() {
		this.gson = new Gson();
	}

	@Override
	public String extractURL(final String baseURL) throws DownloadPluginException {
		return null;
	}

	@Override
	public void setBasePath(final String basePath) {
		this.basePath = basePath;
	}

	/*
	 * (non-Javadoc)
     *
     * @see eu.dnetlib.data.download.rmi.DownloadPlugin#getPluginName()
     */
	@Override
	public String getPluginName() {
		return "HindawiDownloadPlugin";
	}

	@Override
	public Iterable<DownloadItem> retrieveUrls(final Iterable<DownloadItem> urls) throws DownloadPluginException {
		return Iterables.transform(urls, new Function<DownloadItem, DownloadItem>() {

			@Override
			public DownloadItem apply(final DownloadItem input) {
				return retrieveUrl(input);
			}
		});
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.data.download.rmi.DownloadPlugin#retrieveUrl(eu.dnetlib.data.download.rmi.DownloadItem)
	 */
	@Override
	public DownloadItem retrieveUrl(final DownloadItem input) throws DownloadPluginException {

		List<String> inputList = this.gson.fromJson(input.getUrl(), ArrayList.class);
		if (inputList == null || inputList.size() == 0) {
			input.setUrl(null);
			return input;
		}

		for (String fileUrl : inputList) {
			Path inputhPath = FileSystems.getDefault().getPath(basePath).resolve("." + fileUrl);
			if (Files.exists(inputhPath)) {
				input.setOriginalUrl("file://" + inputhPath.toString());
				input.setUrl("file://" + inputhPath.toString());
				return input;
			}
		}
		input.setUrl(null);
		return input;
	}
}
