/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.download.plugin;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.AbstractDownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadPluginException;
import java.util.ArrayList;
import java.util.List;

public class EasyPDFDownloadPlugin
extends AbstractDownloadPlugin
implements DownloadPlugin {
    public DownloadItem retrieveUrl(DownloadItem input) {
        if (this.checkOpenAccess(input) == null) {
            return null;
        }
        if (input == null) {
            return null;
        }
        String url = input.getOriginalUrl();
        if (url == null || url.trim().length() == 0) {
            return input;
        }
        List urls = (List)new Gson().fromJson(url, ArrayList.class);
        if (urls == null || urls.size() == 0) {
            return input;
        }
        if (this.checkUrlsNotNull(input, urls)) {
            return input;
        }
        input.setOriginalUrl(null);
        input.setUrl(null);
        return input;
    }

    public Iterable<DownloadItem> retrieveUrls(Iterable<DownloadItem> urls) {
        return Iterables.transform(urls, (Function)new Function<DownloadItem, DownloadItem>(){

            public DownloadItem apply(DownloadItem input) {
                return EasyPDFDownloadPlugin.this.retrieveUrl(input);
            }
        });
    }

    public String getPluginName() {
        return "easyPDFDownloadPlugin";
    }

    public void setBasePath(String basePath) {
    }

    public String extractURL(String baseURL) throws DownloadPluginException {
        return baseURL.endsWith(".pdf") ? baseURL : null;
    }
}

