/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.download.plugin;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.AbstractDownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadPluginException;
import eu.dnetlib.download.plugin.PathRetreiver;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EuropePMC
extends AbstractDownloadPlugin
implements DownloadPlugin {
    private static final Log log = LogFactory.getLog(EuropePMC.class);
    private String basePath;

    public String getPluginName() {
        return "europePMCDownloadPlugin";
    }

    public Iterable<DownloadItem> retrieveUrls(Iterable<DownloadItem> urls) throws DownloadPluginException {
        return Iterables.transform(urls, (Function)new Function<DownloadItem, DownloadItem>(){

            public DownloadItem apply(DownloadItem input) {
                return EuropePMC.this.retrieveUrl(input);
            }
        });
    }

    public DownloadItem retrieveUrl(DownloadItem input) throws DownloadPluginException {
        try {
            String url = input.getOriginalUrl();
            if (url == null || url.trim().length() == 0) {
                return input;
            }
            List urls = (List)new Gson().fromJson(url, ArrayList.class);
            log.debug((Object)String.format("urls is %s", url));
            if (urls == null || urls.size() == 0) {
                return input;
            }
            input.setFileName(input.getIdItemMetadata());
            Boolean added = false;
            for (String s : urls) {
                if (s.startsWith("http")) {
                    log.debug((Object)String.format("found url starting with http replace original URL with %s", s));
                    input.setOriginalUrl(s);
                    continue;
                }
                if (!s.startsWith("PMC")) continue;
                String correctUrl = s.replace("PMC", "");
                log.debug((Object)String.format("found url starting with PMC %s", correctUrl));
                added = true;
                String path = PathRetreiver.getInstance(this.basePath).getPathForPMCID(Integer.parseInt(correctUrl));
                if (path != null) {
                    input.setUrl("file://" + path);
                    continue;
                }
                input.setUrl(path);
            }
            if (!added.booleanValue()) {
                input.setOriginalUrl(null);
                input.setUrl(null);
            }
            return input;
        }
        catch (Throwable e) {
            log.error((Object)"Exception on Download Plugin");
            log.error((Object)e);
            throw new DownloadPluginException(e);
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String extractURL(String baseURL) throws DownloadPluginException {
        return null;
    }
}

