/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.download.plugin;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.AbstractDownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadPluginException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class DSpacePDFLinkPlugins
extends AbstractDownloadPlugin
implements DownloadPlugin {
    private static final Log log = LogFactory.getLog(DSpacePDFLinkPlugins.class);
    private static final int maxNumberJump = 10;

    private String getHTTPRedirectedURL(String mainURL) throws Exception {
        URL startURL = new URL(mainURL);
        HttpURLConnection conn = (HttpURLConnection)startURL.openConnection();
        conn.setConnectTimeout(5000);
        conn.setInstanceFollowRedirects(true);
        HttpURLConnection.setFollowRedirects(true);
        String location = mainURL;
        int numJump = 1;
        int responseCode = conn.getResponseCode();
        while (responseCode >= 300 && responseCode < 400 && numJump++ < 10) {
            location = conn.getHeaderFields().get("Location").get(0);
            conn.disconnect();
            startURL = new URL(location);
            conn = (HttpURLConnection)startURL.openConnection();
            conn.setConnectTimeout(5000);
            conn.setInstanceFollowRedirects(true);
            HttpURLConnection.setFollowRedirects(true);
            responseCode = conn.getResponseCode();
        }
        conn.disconnect();
        if (responseCode < 200 || responseCode >= 300) {
            return null;
        }
        return location;
    }

    public String extractURL(String url) throws DownloadPluginException {
        try {
            String location = this.getHTTPRedirectedURL(url);
            if (location == null) {
                return null;
            }
            Document doc = Jsoup.connect((String)location).get();
            Elements links = doc.select("meta[content$=.pdf]");
            for (Element link : links) {
                String linkValue = link.attr("content");
                if (this.regularExpression != null) {
                    for (String regex : this.regularExpression) {
                        if (!linkValue.matches(regex)) continue;
                        return linkValue;
                    }
                    continue;
                }
                return linkValue;
            }
            return null;
        }
        catch (Throwable e) {
            throw new DownloadPluginException("Error on extract URL", e);
        }
    }

    public Iterable<DownloadItem> retrieveUrls(Iterable<DownloadItem> urls) {
        return Iterables.transform(urls, input -> this.retrieveUrl((DownloadItem)input));
    }

    public String getPluginName() {
        return "DSpacePDFLinkPlugins";
    }

    public DownloadItem retrieveUrl(DownloadItem input) {
        if (this.checkOpenAccess(input) == null) {
            return null;
        }
        String url = input.getOriginalUrl();
        if (url == null || url.trim().length() == 0) {
            return input;
        }
        List urls = (List)new Gson().fromJson(url, ArrayList.class);
        if (urls == null || urls.size() == 0) {
            return input;
        }
        if (this.checkUrlsNotNull(input, urls)) {
            return input;
        }
        input.setOriginalUrl(null);
        input.setUrl(null);
        return input;
    }

    public void setBasePath(String basePath) {
    }
}

