/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.download.plugin;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.AbstractDownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadPluginException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ELisDownloadPlugin
extends AbstractDownloadPlugin
implements DownloadPlugin {
    private static final Log log = LogFactory.getLog(ELisDownloadPlugin.class);

    public String extractURL(String url) throws DownloadPluginException {
        try {
            Document doc = Jsoup.connect((String)url).get();
            Elements links = doc.select("a[href$=.pdf]");
            for (Element link : links) {
                String linkvalue = link.attr("abs:href");
                if (linkvalue.toLowerCase().contains("thumbnailversion")) continue;
                return linkvalue;
            }
            return null;
        }
        catch (Exception e) {
            throw new DownloadPluginException("Error on extract URL", (Throwable)e);
        }
    }

    public Iterable<DownloadItem> retrieveUrls(Iterable<DownloadItem> urls) {
        return Iterables.transform(urls, (Function)new Function<DownloadItem, DownloadItem>(){

            public DownloadItem apply(DownloadItem input) {
                return ELisDownloadPlugin.this.retrieveUrl(input);
            }
        });
    }

    public String getPluginName() {
        return "ELisDownloadPlugin";
    }

    public DownloadItem retrieveUrl(DownloadItem input) {
        if (this.checkOpenAccess(input) == null) {
            return null;
        }
        String url = input.getOriginalUrl();
        if (url == null || url.trim().length() == 0) {
            return input;
        }
        List urls = (List)new Gson().fromJson(url, ArrayList.class);
        if (urls == null || urls.size() == 0) {
            return input;
        }
        if (this.checkUrlsNotNull(input, urls)) {
            return input;
        }
        input.setOriginalUrl(null);
        input.setUrl(null);
        return input;
    }

    public void setBasePath(String basePath) {
    }
}

