/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.download.plugin;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.AbstractDownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadPluginException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HALPdfDocumentPlugin
extends AbstractDownloadPlugin
implements DownloadPlugin {
    private static final Log log = LogFactory.getLog(HALPdfDocumentPlugin.class);

    public String getPluginName() {
        return "HALPdfDocumentPlugin";
    }

    public Iterable<DownloadItem> retrieveUrls(Iterable<DownloadItem> urls) {
        return Iterables.transform(urls, (Function)new Function<DownloadItem, DownloadItem>(){

            public DownloadItem apply(DownloadItem input) {
                return HALPdfDocumentPlugin.this.retrieveUrl(input);
            }
        });
    }

    public DownloadItem retrieveUrl(DownloadItem input) {
        try {
            if (this.checkOpenAccess(input) == null) {
                return null;
            }
            if (input == null) {
                return null;
            }
            String url = input.getOriginalUrl();
            if (url == null || url.trim().length() == 0) {
                return input;
            }
            List urls = (List)new Gson().fromJson(url, ArrayList.class);
            if (urls == null || urls.size() == 0) {
                return input;
            }
            if (this.checkUrlsNotNull(input, urls)) {
                return input;
            }
            input.setOriginalUrl(null);
            input.setUrl(null);
            return input;
        }
        catch (Throwable e) {
            log.error((Object)"Error on retreiving URL", e);
            input.setOriginalUrl(null);
            input.setUrl(null);
            return input;
        }
    }

    public void setBasePath(String arg0) {
    }

    public String extractURL(String baseURL) throws DownloadPluginException {
        return baseURL.toLowerCase().endsWith("document") ? baseURL : null;
    }
}

