package eu.dnetlib.download.plugin;

import java.util.ArrayList;
import java.util.List;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.AbstractDownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadPluginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/**
 * The Class ELisDownloadPlugin.
 */
public class ELisDownloadPlugin extends AbstractDownloadPlugin implements DownloadPlugin {

    /**
     * The Constant log.
     */
    private static final Log log = LogFactory.getLog(ELisDownloadPlugin.class);

    /**
     * Extract url.
     *
     * @param url the url
     * @return the string
     */
    @Override
    public String extractURL(final String url) throws DownloadPluginException {
        try {
            Document doc = Jsoup.connect(url).get();
            Elements links = doc.select("a[href$=.pdf]");
            for (Element link : links) {
                String linkvalue = link.attr("abs:href");
                if (!linkvalue.toLowerCase().contains("thumbnailversion")) {
                    return linkvalue;
                }
            }
            return null;
        } catch (Exception e) {
            throw new DownloadPluginException("Error on extract URL", e);
        }

    }

    @Override
    public Iterable<DownloadItem> retrieveUrls(final Iterable<DownloadItem> urls) {
        return Iterables.transform(urls, new Function<DownloadItem, DownloadItem>() {

            @Override
            public DownloadItem apply(final DownloadItem input) {
                return retrieveUrl(input);
            }
        });
    }

    /*
     * (non-Javadoc)
     *
     * @see eu.dnetlib.data.download.rmi.DownloadPlugin#getPluginName()
     */
    @Override
    public String getPluginName() {
        return "ELisDownloadPlugin";
    }

    /*
     * (non-Javadoc)
     *
     * @see eu.dnetlib.data.download.rmi.DownloadPlugin#retrieveUrl(eu.dnetlib.data.download.rmi.DownloadItem)
     */
    @Override
    public DownloadItem retrieveUrl(final DownloadItem input) {
        if (checkOpenAccess(input) == null) {
            return null;
        }
        String url = input.getOriginalUrl();

        if (url == null || url.trim().length() == 0) {
            return input;
        }
        @SuppressWarnings("unchecked")
        List<String> urls = new Gson().fromJson(url, ArrayList.class);
        if (urls == null || urls.size() == 0) {
            return input;
        }
        if (checkUrlsNotNull(input, urls))
            return input;
        input.setOriginalUrl(null);
        input.setUrl(null);
        return input;
    }

    @Override
    public void setBasePath(final String basePath) {
        // TODO Auto-generated method stub

    }

}
