package eu.dnetlib.download.plugin;

import java.util.ArrayList;
import java.util.List;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.AbstractDownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadPluginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

// TODO: Auto-generated Javadoc

/**
 * The Class EuropePMC.
 */
public class EuropePMC extends AbstractDownloadPlugin implements DownloadPlugin {

    private static final Log log = LogFactory.getLog(EuropePMC.class);

    /**
     * The base path.
     */
    private String basePath;

    // //*[local-name()='metadata']//*[local-name()='identifier' and ./@identifierType='pmc']/text()

    /*
     * (non-Javadoc)
     *
     * @see eu.dnetlib.data.download.rmi.DownloadPlugin#getPluginName()
     */
    @Override
    public String getPluginName() {
        return "europePMCDownloadPlugin";
    }

    @Override
    public Iterable<DownloadItem> retrieveUrls(final Iterable<DownloadItem> urls) throws DownloadPluginException {
        return Iterables.transform(urls, new Function<DownloadItem, DownloadItem>() {

            @Override
            public DownloadItem apply(final DownloadItem input) {
                return retrieveUrl(input);
            }
        });
    }

    /*
     * (non-Javadoc)
     *
     * @see eu.dnetlib.data.download.rmi.DownloadPlugin#retrieveUrl(eu.dnetlib.data.download.rmi.DownloadItem)
     */
    @Override
    public DownloadItem retrieveUrl(final DownloadItem input) throws DownloadPluginException {

        try {
            String url = input.getOriginalUrl();
            if ((url == null) || (url.trim().length() == 0)) return input;
            @SuppressWarnings("unchecked")
            List<String> urls = new Gson().fromJson(url, ArrayList.class);
            log.debug(String.format("urls is %s", url));
            if ((urls == null) || (urls.size() == 0)) return input;
            input.setFileName(input.getIdItemMetadata());
            Boolean added = false;
            for (String s : urls) {
                if (s.startsWith("http")) {
                    log.debug(String.format("found url starting with http replace original URL with %s", s));
                    input.setOriginalUrl(s);
                } else if (s.startsWith("PMC")) {
                    String correctUrl = s.replace("PMC", "");
                    log.debug(String.format("found url starting with PMC %s", correctUrl));
                    added = true;
                    String path = PathRetreiver.getInstance(basePath).getPathForPMCID(Integer.parseInt(correctUrl));
                    if (path != null) {
                        input.setUrl("file://" + path);
                    } else {
                        input.setUrl(path);
                    }

                }
            }
            if (added == false) {
                input.setOriginalUrl(null);
                input.setUrl(null);
            }
            return input;
        } catch (Throwable e) {
            log.error("Exception on Download Plugin");
            log.error(e);
            throw new DownloadPluginException(e);
        }

    }

    /**
     * Gets the base path.
     *
     * @return the basePath
     */
    public String getBasePath() {
        return basePath;
    }

    /**
     * Sets the base path.
     *
     * @param basePath the basePath to set
     */
    @Override
    public void setBasePath(final String basePath) {
        this.basePath = basePath;
    }

    @Override
    public String extractURL(String baseURL) throws DownloadPluginException {
        return null;
    }
}
