/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.download.plugin;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.AbstractDownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadPluginException;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArxivImportFromFile
extends AbstractDownloadPlugin
implements DownloadPlugin {
    private static final Log log = LogFactory.getLog(ArxivImportFromFile.class);
    private String basePath;

    public DownloadItem retrieveUrl(DownloadItem item) {
        if (this.checkOpenAccess(item) == null) {
            return null;
        }
        String baseURLs = item.getUrl();
        List urlsList = (List)new Gson().fromJson(baseURLs, List.class);
        for (String baseURL : urlsList) {
            if (!baseURL.isEmpty() && baseURL.trim().startsWith("http://")) {
                String name = StringUtils.substringAfter((String)baseURL, (String)"abs/").trim();
                if (name == null) {
                    item.setUrl(null);
                    return item;
                }
                String fileURL = this.createPath(name);
                if (StringUtils.isBlank((CharSequence)fileURL)) {
                    item.setUrl(null);
                    return item;
                }
                File f = new File(fileURL);
                if (f.exists()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("found path associated to " + item.getIdItemMetadata() + " with path : " + fileURL));
                    }
                    item.setUrl("file://" + fileURL);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("NOT found path associated to " + item.getIdItemMetadata() + ": " + fileURL));
                    }
                    item.setUrl(null);
                }
                item.setOriginalUrl(baseURL);
                return item;
            }
            item.setUrl(null);
        }
        return item;
    }

    public String createPath(String name) {
        String regExp = "\\d+\\.\\d+";
        if (name.matches("\\d+\\.\\d+")) {
            String[] values = name.split("\\.");
            Path bsPath = Paths.get(this.basePath, new String[0]);
            Path filePath = Paths.get(String.format("%s/%s.pdf", values[0], name), new String[0]);
            String fileURL = bsPath.resolve(filePath).toString();
            return fileURL;
        }
        if (name.contains("/")) {
            String[] values = name.split("/");
            if (values.length != 2) {
                return null;
            }
            if (values[1].length() > 4) {
                String middle = values[1].substring(0, 4);
                Path bsPath = Paths.get(this.basePath, new String[0]);
                Path filePath = Paths.get(String.format("%s/%s.pdf", middle, name.replace("/", "")), new String[0]);
                String fileURL = bsPath.resolve(filePath).toString();
                return fileURL;
            }
        }
        return null;
    }

    public Iterable<DownloadItem> retrieveUrls(Iterable<DownloadItem> items) {
        return Iterables.transform(items, input -> this.retrieveUrl((DownloadItem)input));
    }

    public String getPluginName() {
        return "ArxivImportFromFile";
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String extractURL(String baseURL) throws DownloadPluginException {
        return null;
    }
}

