/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.download.plugin;

import eu.dnetlib.download.plugin.InfoPath;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PathRetreiver {
    private static final Log log = LogFactory.getLog(PathRetreiver.class);
    private static PathRetreiver instance;
    private String base_path;
    private TreeMap<Integer, InfoPath> values;

    public static PathRetreiver getInstance(String base_path) {
        if (instance == null) {
            instance = new PathRetreiver();
            instance.setBase_path(base_path);
        }
        return instance;
    }

    private void bootstrap() {
        this.values = new TreeMap();
        File basePath = new File(this.base_path);
        File[] selectedFiles = basePath.listFiles(pathname -> pathname.isDirectory());
        for (File f : selectedFiles) {
            String lower = StringUtils.substringAfter((String)StringUtils.substringBefore((String)f.getName(), (String)"_"), (String)"PMC");
            String upper = StringUtils.substringAfter((String)StringUtils.substringAfter((String)f.getName(), (String)"_"), (String)"PMC");
            String path = f.getPath();
            InfoPath i = new InfoPath();
            i.setLower(Integer.parseInt(lower));
            i.setUpper(Integer.parseInt(upper));
            i.setPath(path);
            this.values.put(i.getLower(), i);
        }
        if (log.isDebugEnabled()) {
            for (InfoPath p : this.values.values()) {
                log.debug((Object)String.format("%s -- %s : %s", p.getLower(), p.getUpper(), p.getPath()));
            }
        }
    }

    public String getPathForPMCID(int pmcID) {
        Map.Entry<Integer, InfoPath> infoPath;
        if (this.values == null) {
            this.bootstrap();
        }
        if ((infoPath = this.values.floorEntry(pmcID)) != null) {
            String currentPath = infoPath.getValue().getPath() + "/" + pmcID + ".xml";
            File f = new File(currentPath);
            log.debug((Object)String.format("try to search in path %s", currentPath));
            String s = null;
            if (f.exists()) {
                s = f.getPath();
                log.debug((Object)String.format("found in %s", s));
            } else {
                log.debug((Object)String.format("not found in %s", s));
            }
            return s;
        }
        log.debug((Object)String.format("PMC with ID: %s not found", pmcID));
        return null;
    }

    public void setBase_path(String base_path) {
        this.base_path = base_path;
    }

    public String getBase_path() {
        return this.base_path;
    }
}

