package eu.dnetlib.download.plugin;

import java.util.ArrayList;
import java.util.List;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.AbstractDownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadPluginException;

/**
 * @Deprecated: use ArxivImportFromFile instead
 */
@Deprecated
public class ArxivDownloadPlugin extends AbstractDownloadPlugin implements DownloadPlugin {

    @Override
    public DownloadItem retrieveUrl(final DownloadItem input) {
        if (checkOpenAccess(input) == null) {
            return null;
        }
        String url = input.getOriginalUrl();
        if (url == null || url.trim().length() == 0) {
            return input;
        }
        @SuppressWarnings("unchecked")
        List<String> urls = new Gson().fromJson(url, ArrayList.class);
        if (urls == null || urls.size() == 0) {
            return input;
        }
        for (String s : urls) {
            if (s.startsWith("http")) {
                input.setOriginalUrl(s);
                String correctUrl = s.replace("abs", "pdf");
                correctUrl += ".pdf";
                input.setUrl(correctUrl);
            }
        }
        return input;
    }

    @Override
    public Iterable<DownloadItem> retrieveUrls(final Iterable<DownloadItem> urls) {
        return Iterables.transform(urls, new Function<DownloadItem, DownloadItem>() {

            @Override
            public DownloadItem apply(final DownloadItem input) {
                return retrieveUrl(input);
            }
        });
    }

    @Override
    public String getPluginName() {
        return "ArxivDownloadPlugin";
    }

    @Override
    public void setBasePath(final String basePath) {

    }

    @Override
    public String extractURL(String baseURL) throws DownloadPluginException {
        return null;
    }
}
