package eu.dnetlib.data.download.plugins;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.AbstractDownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;

import java.util.ArrayList;
import java.util.List;

public class DummyPlugin extends AbstractDownloadPlugin implements DownloadPlugin {


    @Override
    public void setBasePath(String basePath) {

    }

    @Override
    public DownloadItem retrieveUrl(final DownloadItem item) {
        if (checkOpenAccess(item) == null) {
            return null;
        }
        if (filterByRegexp(item) == null) return null;
        String url = item.getUrl();

        if ((url == null) || (url.trim().length() == 0)) return null;
        @SuppressWarnings("unchecked")
        List<String> urls = new Gson().fromJson(url, ArrayList.class);
        if ((urls == null) || (urls.size() == 0)) {
            item.setOriginalUrl(null);
            item.setUrl(null);
            return item;
        }
        item.setOriginalUrl(urls.get(0));
        item.setUrl(urls.get(0));
        return item;
    }

    @Override
    public Iterable<DownloadItem> retrieveUrls(final Iterable<DownloadItem> items) {
        return Iterables.transform(items, new Function<DownloadItem, DownloadItem>() {

            @Override
            public DownloadItem apply(final DownloadItem input) {
                return retrieveUrl(input);
            }
        });
    }

    @Override
    public String getPluginName() {
        return "DummyPlugin";
    }


    @Override
    public String extractURL(String baseURL) {
        return null;
    }
}
