/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.download.rmi;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import eu.dnetlib.data.download.DownloadPluginEnumeratorImpl;
import eu.dnetlib.data.download.DownloadReport;
import eu.dnetlib.data.download.DownloadReportMap;
import eu.dnetlib.data.download.DownloadServiceImpl;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadServiceException;
import eu.dnetlib.data.download.worker.DownloadWorker;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStoreDao;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DownloadServiceFeeder {
    private static final Log log = LogFactory.getLog(DownloadServiceFeeder.class);
    private static final int MAX_NUM_FOUND = 10;
    @Resource
    DownloadPluginEnumeratorImpl downloadPluginEnumerator;
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    @Autowired
    private ObjectStoreDao objectStoreDao;

    public static void reportException(DownloadReportMap report, DownloadItem di, Throwable e) {
        String className = e.getClass().getName();
        if (!report.containsKey(className)) {
            DownloadReport dr = new DownloadReport();
            dr.setStackTrace(Joiner.on((String)"\tat ").join((Object[])e.getStackTrace()));
            if (di != null) {
                dr.setDownloadItem(di);
            }
            report.put(className, dr);
        } else {
            ((DownloadReport)report.get(className)).incrementError();
        }
    }

    public DownloadReportMap download(String epr, String plugin, String objectStoreID, String protocol, String mimeType, int numberOfThreads, String basePath, List<String> regularExpression, int connectTimeoutMs, int readTimeoutMs, int sleepTimeMs) throws DownloadServiceException, ObjectStoreServiceException {
        int i;
        final DownloadPlugin downloadPlugin = this.downloadPluginEnumerator.get(plugin);
        if (basePath != null && !basePath.isEmpty()) {
            downloadPlugin.setBasePath(basePath);
        }
        IterableResultSetClient urlInfo = this.resultSetClientFactory.getClient(epr);
        ArrayBlockingQueue itemsQueue = Queues.newArrayBlockingQueue((int)1024);
        ExecutorService executor = Executors.newFixedThreadPool(numberOfThreads);
        ObjectStore objStore = this.objectStoreDao.getObjectStore(objectStoreID);
        ArrayList responses = Lists.newArrayList();
        final DownloadReportMap pluginReport = new DownloadReportMap();
        pluginReport.setStatus(true);
        if (regularExpression != null) {
            downloadPlugin.setRegularExpression(regularExpression);
        }
        for (i = 0; i < numberOfThreads; ++i) {
            responses.add(executor.submit(new DownloadWorker(itemsQueue, objStore, Protocols.valueOf((String)protocol), mimeType, connectTimeoutMs, readTimeoutMs, sleepTimeMs, new Function<String, DownloadItem>(){

                public DownloadItem apply(String input) {
                    if (input == null) {
                        log.debug((Object)"Input is null");
                        return null;
                    }
                    if (input.equals("END_DOWNLOAD")) {
                        return DownloadServiceImpl.END_QUEUE;
                    }
                    DownloadItem di = null;
                    try {
                        di = DownloadItem.newObjectfromJSON((String)input);
                        if (downloadPlugin.retrieveUrl(di) == null) {
                            di.setUrl(null);
                            di.setOriginalUrl(null);
                        }
                        return di;
                    }
                    catch (Throwable e) {
                        DownloadServiceFeeder.reportException(pluginReport, di, e);
                        log.debug((Object)("Exception on transform item :" + input), e);
                        return null;
                    }
                }
            })));
        }
        i = 0;
        int null_found = 0;
        if (urlInfo != null) {
            for (String downloadItem : urlInfo) {
                if (downloadItem != null) {
                    null_found = 0;
                    if (i++ % 1000 == 0) {
                        log.debug((Object)("Read " + i));
                    }
                    try {
                        itemsQueue.put(downloadItem);
                    }
                    catch (Exception e) {
                        log.error((Object)("An error occurred while populating the download items queue: " + Joiner.on((String)"\tat ").join((Object[])e.getStackTrace())));
                    }
                    continue;
                }
                if (null_found++ <= 10) continue;
                break;
            }
        }
        try {
            itemsQueue.put("END_DOWNLOAD");
        }
        catch (InterruptedException e) {
            log.error((Object)("An error occurred adding the loop terminator: " + Joiner.on((String)"\tat ").join((Object[])e.getStackTrace())));
        }
        DownloadReportMap resultMap = this.getDownloadReportMap(responses, pluginReport);
        executor.shutdown();
        return resultMap;
    }

    private DownloadReportMap getDownloadReportMap(List<Future<DownloadReportMap>> responses, DownloadReportMap pluginReport) {
        DownloadReportMap resultMap = new DownloadReportMap();
        resultMap.setStatus(true);
        for (Future<DownloadReportMap> currentResponse : responses) {
            try {
                DownloadReportMap currentMap = currentResponse.get();
                this.mergeReport(resultMap, currentMap);
                log.info((Object)("Status " + currentMap.getStatus()));
                resultMap.setStatus(resultMap.getStatus() && currentMap.getStatus());
                resultMap.setTotalDownloaded(currentMap.getTotalDownloaded() + resultMap.getTotalDownloaded());
            }
            catch (Exception e) {
                log.error((Object)e);
                resultMap.setStatus(false);
            }
        }
        this.mergeReport(resultMap, pluginReport);
        return resultMap;
    }

    private void mergeReport(DownloadReportMap resultMap, DownloadReportMap currentMap) {
        for (String key : currentMap.keySet()) {
            if (!resultMap.containsKey(key)) {
                resultMap.put(key, currentMap.get(key));
            } else {
                DownloadReport currentReport = (DownloadReport)currentMap.get(key);
                ((DownloadReport)resultMap.get(key)).incrementError(currentReport.getNumberOfOccurrences());
            }
            resultMap.setTotalDownloaded(resultMap.getTotalDownloaded() + currentMap.getTotalDownloaded());
            resultMap.setStatus(resultMap.getStatus() & currentMap.getStatus());
        }
    }
}

