/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.download;

import eu.dnetlib.data.download.DownloadPluginEnumeratorImpl;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadService;
import eu.dnetlib.data.download.rmi.DownloadServiceException;
import eu.dnetlib.data.download.rmi.DownloadServiceFeeder;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;

public class DownloadServiceImpl
extends AbstractBaseService
implements DownloadService {
    public static final DownloadItem END_QUEUE = new DownloadItem();
    public static final String END_QUEUE_STRING = "END_DOWNLOAD";
    private static final Log log = LogFactory.getLog(DownloadServiceImpl.class);
    private static int DEFAULT_CONNECT_TIMEOUT_MS = 5000;
    private static int DEFAULT_READ_TIMEOUT_MS = 5000;
    @Resource
    private DownloadPluginEnumeratorImpl downloadPluginEnumerator;
    @Resource
    private DownloadServiceFeeder downloadfeeder;
    private NotificationHandler notificationHandler;
    @Value(value="${services.download.http.sslcheck}")
    private boolean checkCerts;
    @Value(value="${services.download.https.protocols}")
    private String httpsProtocols;

    public void downloadFromResultSet(W3CEndpointReference resultSet, String plugin, String objectStoreID, String protocol, String mimeType) throws DownloadServiceException {
        log.info((Object)String.format("download using plugin '%s' , protocol '%s' into ObjectStore '%s'", plugin, protocol, objectStoreID));
        try {
            this.downloadfeeder.download(resultSet.toString(), plugin, objectStoreID, protocol, mimeType, 5, null, null, DEFAULT_CONNECT_TIMEOUT_MS, DEFAULT_READ_TIMEOUT_MS, 0);
        }
        catch (ObjectStoreServiceException e) {
            log.error((Object)e);
        }
        log.info((Object)String.format("download completed using plugin '%s' , protocol '%s' into ObjectStore '%s'", plugin, protocol, objectStoreID));
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        this.getNotificationHandler().notified(subscriptionId, topic, isId, message);
    }

    public void start() {
        if (!this.checkCerts) {
            log.info((Object)"disabling SSL check ...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DownloadServiceImpl.this.disableSslVerification();
                }
            }).start();
        }
    }

    private void disableSslVerification() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            log.info((Object)"disabled SSL check");
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (KeyManagementException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public DownloadServiceFeeder getDownloadfeeder() {
        return this.downloadfeeder;
    }

    public void setDownloadfeeder(DownloadServiceFeeder downloadfeeder) {
        this.downloadfeeder = downloadfeeder;
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Required
    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public List<String> listPlugins() throws DownloadServiceException {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.downloadPluginEnumerator.getAll().keySet());
        return result;
    }
}

