/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.filesystem;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;
import eu.dnetlib.data.objectstore.filesystem.FileSystemObjectStore;
import eu.dnetlib.data.objectstore.filesystem.FileSystemUtility;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStoreDao;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFileNotFoundException;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;

public class FileSystemObjectStoreDao
implements ObjectStoreDao {
    public static final String INTERPRETATION_FIELD = "interpretation";
    public static final String OBJECTSTORE_METADATA_NAME_FIELD = "metadataObjectStore";
    public static final String OBJECTSTORE_ID_FIELD = "obsId";
    public static final String BASE_PATH_FIELD = "basePath";
    private static final Log log = LogFactory.getLog(FileSystemObjectStoreDao.class);
    private static final String OBJECTSTORE_PROFILE_SUFFIX = "_T2JqZWN0U3RvcmVEU1Jlc291cmNlcy9PYmplY3RTdG9yZURTUmVzb3VyY2VUeXBl";
    @Resource(name="objectstoreMongoDB")
    private MongoDatabase db;
    private boolean upsert;
    private String objectStoreRESTURI;

    public ObjectStore getObjectStore(String obsId) throws ObjectStoreServiceException {
        String currentId = obsId.substring(0, 36);
        String find_id = obsId;
        if (find_id.length() == 36) {
            find_id = find_id + OBJECTSTORE_PROFILE_SUFFIX;
        }
        MongoCollection metadataObjectStore = this.getDb().getCollection(OBJECTSTORE_METADATA_NAME_FIELD, DBObject.class);
        Bson query = Filters.eq((String)OBJECTSTORE_ID_FIELD, (Object)find_id);
        log.debug((Object)("QUERY :" + query.toString()));
        DBObject resultQuery = (DBObject)metadataObjectStore.find(query).first();
        log.debug((Object)("result " + resultQuery));
        if (resultQuery == null) {
            throw new ObjectStoreFileNotFoundException("the objectStore with identifier: " + obsId + " was not found");
        }
        String basePath = resultQuery.get(BASE_PATH_FIELD).toString();
        String interpretation = resultQuery.get(INTERPRETATION_FIELD).toString();
        if (!resultQuery.containsField(BASE_PATH_FIELD) || StringUtils.isBlank((String)basePath)) {
            throw new ObjectStoreServiceException("Can't Get Objectstore, the metadata doesn't contain info about the basepath");
        }
        MongoCollection collection = this.getDb().getCollection(currentId, DBObject.class);
        return new FileSystemObjectStore(currentId, interpretation, basePath, (MongoCollection<DBObject>)collection, this.objectStoreRESTURI);
    }

    public List<String> listObjectStores() {
        MongoCollection metadata = this.getDb().getCollection(OBJECTSTORE_METADATA_NAME_FIELD, DBObject.class);
        return MappedCollection.listMap((Iterable)metadata.find(), (UnaryFunction)new UnaryFunction<String, DBObject>(){

            public String evaluate(DBObject object) {
                return (String)object.get(FileSystemObjectStoreDao.OBJECTSTORE_ID_FIELD);
            }
        });
    }

    public boolean createObjectStore(String obsId, String interpretation, String basePath) throws ObjectStoreServiceException {
        log.debug((Object)String.format("Create object Store method\n\t Id:%s  Interpretation:%s BasePath : %s", obsId, interpretation, basePath));
        if (StringUtils.isBlank((String)basePath)) {
            throw new ObjectStoreServiceException("Can't create the object store: the base path cannot be blank");
        }
        Path path = FileSystems.getDefault().getPath(basePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            throw new ObjectStoreServiceException("Can't create the object store: base path: '" + basePath + "' doesn't exist or it is not a folder");
        }
        try {
            String currentObsId = obsId.substring(0, 36);
            log.debug((Object)("Cleaned objectStore Id " + currentObsId));
            if (Files.exists(path.resolve(currentObsId), new LinkOption[0])) {
                throw new ObjectStoreServiceException("Can't create the object store: base path: '" + path.resolve(currentObsId) + "' already exists");
            }
            Files.createDirectory(path.resolve(currentObsId), new FileAttribute[0]);
            MongoCollection coll = this.getDb().getCollection(OBJECTSTORE_METADATA_NAME_FIELD, DBObject.class);
            BasicDBObject obj = new BasicDBObject();
            obj.put((Object)OBJECTSTORE_ID_FIELD, (Object)obsId);
            obj.put((Object)INTERPRETATION_FIELD, (Object)interpretation);
            obj.put((Object)BASE_PATH_FIELD, (Object)basePath);
            coll.insertOne((Object)obj);
            MongoCollection objectStore = this.getDb().getCollection(currentObsId, DBObject.class);
            objectStore.createIndex((Bson)new BasicDBObject("id", (Object)1));
            objectStore.createIndex((Bson)new BasicDBObject("timestamp", (Object)1));
            return true;
        }
        catch (Throwable e) {
            throw new ObjectStoreServiceException("Can't Create the object Store id: '" + obsId, e);
        }
    }

    public boolean updateObjectStore(String obsId, String interpretation) {
        MongoCollection coll = this.getDb().getCollection(OBJECTSTORE_METADATA_NAME_FIELD, DBObject.class);
        BasicDBObject obj = new BasicDBObject();
        obj.put((Object)"$set", (Object)new BasicDBObject(INTERPRETATION_FIELD, (Object)interpretation));
        UpdateResult updateResult = coll.updateOne(Filters.eq((String)OBJECTSTORE_ID_FIELD, (Object)obsId), (Bson)obj);
        if (updateResult.isModifiedCountAvailable()) {
            log.debug((Object)("Matched / Modified " + updateResult.getMatchedCount() + " / " + updateResult.getModifiedCount()));
        }
        return true;
    }

    public boolean deleteObjectStore(String obsId) throws ObjectStoreServiceException {
        MongoCollection coll = this.getDb().getCollection(OBJECTSTORE_METADATA_NAME_FIELD, DBObject.class);
        Bson query = Filters.eq((String)OBJECTSTORE_ID_FIELD, (Object)obsId);
        DBObject resultQuery = (DBObject)coll.find(query).first();
        String basePath = this.checkAndGetFsPathField(resultQuery, obsId);
        String currentObsId = obsId.substring(0, 36);
        Path basePathFS = FileSystems.getDefault().getPath(basePath, currentObsId);
        if (!Files.exists(basePathFS, new LinkOption[0])) {
            throw new ObjectStoreServiceException("Can't Delete ObjectStore " + obsId + ": the base path does not exist :" + basePathFS);
        }
        try {
            FileSystemUtility.deleteFolderRecursive(basePathFS);
        }
        catch (IOException e) {
            throw new ObjectStoreServiceException("Can't Delete ObjectStore " + obsId, (Throwable)e);
        }
        coll.deleteOne(Filters.eq((String)OBJECTSTORE_ID_FIELD, (Object)obsId));
        this.getDb().getCollection(obsId).drop();
        return true;
    }

    public boolean dropContent(String obsId) throws ObjectStoreServiceException {
        return this.getObjectStore(obsId).dropContent();
    }

    private String checkAndGetFsPathField(DBObject resultQuery, String objectStoreID) throws ObjectStoreServiceException {
        if (resultQuery == null || !resultQuery.containsField(BASE_PATH_FIELD)) {
            throw new ObjectStoreServiceException("ObjectStore with identifier :" + objectStoreID + " not found or missing " + BASE_PATH_FIELD + " field");
        }
        String pathStr = (String)resultQuery.get(BASE_PATH_FIELD);
        if (StringUtils.isBlank((String)pathStr)) {
            throw new ObjectStoreServiceException("ObjectStore with identifier :" + objectStoreID + " with blank " + BASE_PATH_FIELD);
        }
        return pathStr;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public void setUpsert(boolean upsert) {
        this.upsert = upsert;
    }

    public String getObjectStoreRESTURI() {
        return this.objectStoreRESTURI;
    }

    public void setObjectStoreRESTURI(String objectStoreRESTURI) {
        this.objectStoreRESTURI = objectStoreRESTURI;
    }

    public MongoDatabase getDb() {
        return this.db;
    }

    public void setDb(MongoDatabase db) {
        this.db = db;
    }
}

