/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.filesystem;

import com.mongodb.DBObject;
import eu.dnetlib.data.objectstore.filesystem.ModularObjectStoreRESTService;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectStoreFileUtility {
    private static final int KB_SIZE = 1024;
    private static final Log log = LogFactory.getLog(ObjectStoreFileUtility.class);

    public static ObjectStoreFile build(DBObject metadata, String baseURI, String objectStoreID, String basePath) {
        String originalFile = (String)metadata.get("originalObject");
        ObjectStoreFile original = ObjectStoreFile.createObject((String)originalFile);
        ObjectStoreFile newFile = new ObjectStoreFile();
        newFile.setObjectID((String)metadata.get("id"));
        newFile.setAccessProtocol(Protocols.HTTP);
        newFile.setMimeType((String)metadata.get("mime"));
        newFile.setMd5Sum((String)metadata.get("md5Sum"));
        try {
            newFile.setFileSizeKB(Long.parseLong(metadata.get("size").toString()) / 1024L);
        }
        catch (Throwable e) {
            log.error((Object)"Error on getting file size", e);
        }
        if (originalFile != null) {
            newFile.setMetadataRelatedID(original.getMetadataRelatedID());
            if (StringUtils.isBlank((String)original.getDownloadedURL())) {
                newFile.setDownloadedURL(original.getURI());
            } else {
                newFile.setDownloadedURL(original.getDownloadedURL());
            }
        }
        try {
            newFile.setURI(ModularObjectStoreRESTService.retrieveURL(baseURI, basePath, objectStoreID, newFile.getObjectID()));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Error on Build objectStoreFile ", (Throwable)e);
        }
        return newFile;
    }

    public static UnaryFunction<String, DBObject> asJSON(String baseURI, String objectStoreID, String basePath) {
        return input -> ObjectStoreFileUtility.build(input, baseURI, objectStoreID, basePath).toJSON();
    }
}

