/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.filesystem;

import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemUtility {
    private static final Log log = LogFactory.getLog(FileSystemUtility.class);

    public static Pair<String, Long> saveAndGenerateMD5(InputStream inputStream, Path filePath) {
        if (inputStream == null) {
            return null;
        }
        String md5 = null;
        long size = 0L;
        try {
            Files.copy(inputStream, filePath, new CopyOption[0]);
            FileInputStream fis = new FileInputStream(filePath.toFile());
            md5 = DigestUtils.md5Hex((InputStream)fis);
            fis.close();
            size = Files.size(filePath);
        }
        catch (IOException e1) {
            log.error((Object)e1);
        }
        return new Pair(md5, (Object)size);
    }

    public static boolean deleteFolderRecursive(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        return true;
    }

    public static Path objectStoreFilePath(String basePath, String objectStoreId, String objectIdentifier) {
        Path baseDirPath = FileSystems.getDefault().getPath(basePath, new String[0]).resolve(objectStoreId);
        String md5id = DnetXsltFunctions.md5((String)objectIdentifier);
        String firstLevel = StringUtils.substring((String)md5id, (int)0, (int)2);
        String secondLevel = StringUtils.substring((String)md5id, (int)2, (int)4);
        String fileName = StringUtils.substring((String)md5id, (int)4) + ".obj";
        return baseDirPath.resolve(firstLevel).resolve(secondLevel).resolve(fileName);
    }
}

