/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.filesystem;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.DeleteResult;
import eu.dnetlib.data.objectstore.filesystem.FileSystemObjectStoreResultSetListener;
import eu.dnetlib.data.objectstore.filesystem.FileSystemUtility;
import eu.dnetlib.data.objectstore.filesystem.ModularObjectStoreRESTService;
import eu.dnetlib.data.objectstore.filesystem.ObjectStoreFileUtility;
import eu.dnetlib.data.objectstore.modular.ObjectStoreRecord;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.rmi.MetadataObjectRecord;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFileNotFoundException;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.miscutils.collections.Pair;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;

public class FileSystemObjectStore
implements ObjectStore {
    private static final String URI_FIELD = "uri";
    private static final String FS_PATH_FIELD = "fsPath";
    private static final Log log = LogFactory.getLog(FileSystemObjectStore.class);
    private final String id;
    private final String interpretation;
    private final String basePath;
    private final String baseURI;
    private final MongoCollection<DBObject> mongoMetadata;

    public FileSystemObjectStore(String identifier, String interpretation, String basePath, MongoCollection<DBObject> mongoMetadata, String baseURI) {
        this.id = identifier;
        this.basePath = basePath;
        this.interpretation = interpretation;
        this.mongoMetadata = mongoMetadata;
        this.baseURI = baseURI;
    }

    public String getId() {
        return this.id;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public int feed(Iterable<ObjectStoreRecord> records, boolean incremental) throws ObjectStoreServiceException {
        if (records == null) {
            return 0;
        }
        Path baseDirPath = FileSystems.getDefault().getPath(this.getBasePath(), new String[0]).resolve(this.getId());
        if (!Files.exists(baseDirPath, new LinkOption[0])) {
            throw new ObjectStoreServiceException("Error can't feed objects because the folder " + baseDirPath + " does not exist");
        }
        int addedCounter = 0;
        int nulls = 0;
        for (ObjectStoreRecord record : records) {
            String url = this.feedObject(record);
            if (StringUtils.isNotBlank((CharSequence)url)) {
                ++addedCounter;
                continue;
            }
            ++nulls;
        }
        if (nulls > 0) {
            log.warn((Object)String.format("Found %s null records", nulls));
        }
        return addedCounter;
    }

    public int feedMetadataRecord(Iterable<MetadataObjectRecord> records, boolean incremental) throws ObjectStoreServiceException {
        Iterable it = Iterables.transform(records, mor -> {
            ObjectStoreRecord r = new ObjectStoreRecord();
            r.setInputStream((InputStream)new ByteArrayInputStream(mor.getRecord().getBytes()));
            ObjectStoreFile fileMetadata = new ObjectStoreFile();
            fileMetadata.setObjectID(mor.getId());
            fileMetadata.setMimeType(mor.getMime());
            r.setFileMetadata(fileMetadata);
            return r;
        });
        return this.feed(it, incremental);
    }

    public String feedObjectRecord(ObjectStoreRecord record) throws ObjectStoreServiceException {
        return this.feedObject(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String feedObject(ObjectStoreRecord record) {
        String objectIdentifier;
        if (record != null && StringUtils.isNotBlank((CharSequence)(objectIdentifier = record.getFileMetadata().getObjectID()))) {
            Path objResolvedPath = FileSystemUtility.objectStoreFilePath(this.basePath, this.id, objectIdentifier);
            if (Files.notExists(objResolvedPath, new LinkOption[0])) {
                try {
                    log.debug((Object)("Creation of folder " + objResolvedPath.getParent()));
                    Files.createDirectories(objResolvedPath.getParent(), new FileAttribute[0]);
                    log.debug((Object)("Folder " + objResolvedPath.getParent() + " created"));
                    String md5Sum = null;
                    Long size = new Long(0L);
                    if (record.getInputStream() != null) {
                        Pair<String, Long> infos = FileSystemUtility.saveAndGenerateMD5(record.getInputStream(), objResolvedPath);
                        md5Sum = (String)infos.getKey();
                        size = (Long)infos.getValue();
                    }
                    String url = ModularObjectStoreRESTService.retrieveURL(this.getBaseURI(), this.getBasePath(), this.getId(), record.getFileMetadata().getObjectID());
                    if (StringUtils.isNotBlank((CharSequence)md5Sum)) {
                        double timestamp = System.currentTimeMillis();
                        BasicDBObject metadata = new BasicDBObject();
                        metadata.put((Object)"id", (Object)record.getFileMetadata().getObjectID());
                        metadata.put((Object)"mime", (Object)record.getFileMetadata().getMimeType());
                        metadata.put((Object)"originalObject", (Object)record.getFileMetadata().toJSON());
                        metadata.put((Object)"timestamp", (Object)timestamp);
                        metadata.put((Object)"md5Sum", (Object)md5Sum);
                        metadata.put((Object)"size", (Object)size);
                        metadata.put((Object)FS_PATH_FIELD, (Object)objResolvedPath.toAbsolutePath().toString());
                        metadata.put((Object)URI_FIELD, (Object)url);
                        log.debug((Object)("saving metadata object to the collection: " + metadata.toString()));
                        this.mongoMetadata.insertOne((Object)metadata);
                    }
                    String string = url;
                    return string;
                }
                catch (Exception e) {
                    log.error((Object)"Something bad happen on inserting Record", (Throwable)e);
                    log.error((Object)("Record: " + new Gson().toJson((Object)record.getFileMetadata())));
                }
                finally {
                    if (record.getInputStream() != null) {
                        try {
                            record.getInputStream().close();
                        }
                        catch (Exception e) {
                            log.error((Object)"Error on close inputStream", (Throwable)e);
                        }
                    }
                }
            }
            log.debug((Object)("The File in the path" + objResolvedPath.getParent() + "exists "));
        }
        return null;
    }

    public ResultSetListener deliver(Long from, Long until) throws ObjectStoreServiceException {
        FileSystemObjectStoreResultSetListener resultSet = new FileSystemObjectStoreResultSetListener();
        resultSet.setBaseURI(this.getBaseURI());
        resultSet.setMongoCollection(this.mongoMetadata);
        resultSet.setObjectStoreID(this.getId());
        resultSet.setFromDate(from);
        resultSet.setUntilDate(until);
        resultSet.setBasePath(this.getBasePath());
        return resultSet;
    }

    public ResultSetListener deliverIds(Iterable<String> ids) throws ObjectStoreServiceException {
        FileSystemObjectStoreResultSetListener resultSet = new FileSystemObjectStoreResultSetListener();
        resultSet.setBaseURI(this.getBaseURI());
        resultSet.setMongoCollection(this.mongoMetadata);
        resultSet.setObjectStoreID(this.getId());
        resultSet.setRecords(Lists.newArrayList(ids));
        resultSet.setBasePath(this.basePath);
        return resultSet;
    }

    public ObjectStoreFile deliverObject(String objectId) throws ObjectStoreServiceException {
        Bson query = Filters.eq((String)"id", (Object)objectId);
        DBObject resultQuery = (DBObject)this.mongoMetadata.find(query).first();
        this.checkAndGetFsPathField(resultQuery, objectId);
        return ObjectStoreFileUtility.build(resultQuery, this.getBaseURI(), this.getId(), this.basePath);
    }

    private String checkAndGetFsPathField(DBObject resultQuery, String objectId) throws ObjectStoreServiceException {
        if (resultQuery == null || !resultQuery.containsField(FS_PATH_FIELD)) {
            throw new ObjectStoreFileNotFoundException("Object with identifier :" + objectId + " not found or missing " + FS_PATH_FIELD + " field");
        }
        String pathStr = (String)resultQuery.get(FS_PATH_FIELD);
        if (StringUtils.isBlank((CharSequence)pathStr)) {
            throw new ObjectStoreFileNotFoundException("Object with identifier :" + objectId + " with blank " + FS_PATH_FIELD);
        }
        return pathStr;
    }

    public int getSize() throws ObjectStoreServiceException {
        return (int)this.mongoMetadata.count();
    }

    public void deleteObject(String objectId) throws ObjectStoreServiceException {
        Bson query = Filters.eq((String)"id", (Object)objectId);
        DBObject response = (DBObject)this.mongoMetadata.find(query).first();
        String pathStr = this.checkAndGetFsPathField(response, objectId);
        Path path = FileSystems.getDefault().getPath(pathStr, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new ObjectStoreFileNotFoundException("Object with identifier :" + objectId + " not found in the assigned path " + path);
        }
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            throw new ObjectStoreServiceException("An error occurs on delete file ", (Throwable)e);
        }
        this.mongoMetadata.deleteOne(query);
    }

    public String getObject(String recordId) throws ObjectStoreServiceException {
        Bson query = Filters.eq((String)"id", (Object)recordId);
        DBObject response = (DBObject)this.mongoMetadata.find(query).first();
        if (response == null || !response.containsField(URI_FIELD)) {
            return null;
        }
        return (String)response.get(URI_FIELD);
    }

    public boolean existIDStartsWith(String startId) throws ObjectStoreServiceException {
        Bson query = Filters.regex((String)"id", (Pattern)Pattern.compile(startId));
        return this.mongoMetadata.count(query) > 0L;
    }

    public boolean dropContent() throws ObjectStoreServiceException {
        if (this.getBasePath() == null) {
            throw new ObjectStoreServiceException("Error on dropping object store base_path required");
        }
        Path baseDirPath = FileSystems.getDefault().getPath(this.getBasePath(), new String[0]).resolve(this.getId());
        try {
            FileSystemUtility.deleteFolderRecursive(baseDirPath);
        }
        catch (IOException e) {
            throw new ObjectStoreServiceException("Error on dropping store ", (Throwable)e);
        }
        log.info((Object)("Deleted folder" + baseDirPath.toString()));
        if (!Files.exists(baseDirPath, new LinkOption[0])) {
            log.info((Object)("Recreating folder " + baseDirPath));
            try {
                Files.createDirectory(baseDirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ObjectStoreServiceException("Error on dropping store ", (Throwable)e);
            }
        }
        DeleteResult deleteResult = this.mongoMetadata.deleteMany((Bson)new BasicDBObject());
        log.info((Object)("Dropped content for object store " + this.id + ". " + deleteResult.getDeletedCount() + " object(s) deleted."));
        return true;
    }

    public String toString() {
        return "FileSystemObjectStore{id='" + this.getId() + '\'' + ", interpretation='" + this.getInterpretation() + '\'' + ", basePath='" + this.getBasePath() + '\'' + ", baseURI='" + this.getBaseURI() + '\'' + '}';
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getBasePath() {
        return this.basePath;
    }
}

