/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.filesystem;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import eu.dnetlib.data.objectstore.filesystem.FileSystemObjectStoreDao;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStoreDao;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;

public class IndexIntegrityChecker {
    private static final Log log = LogFactory.getLog(IndexIntegrityChecker.class);
    @Autowired
    private ObjectStoreDao dao;

    public void check() {
        this.checkIndexes();
    }

    private void checkIndexes() {
        log.info((Object)"objectStore indexes integrity start");
        MongoDatabase db = ((FileSystemObjectStoreDao)this.dao).getDb();
        IndexOptions bg = new IndexOptions().background(true);
        for (String objectStoreId : this.dao.listObjectStores()) {
            String id = StringUtils.substringBefore((String)objectStoreId, (String)"_");
            MongoCollection objectStore = db.getCollection(id, DBObject.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("creating index (id, timestamp) on objectStore %s", id));
            }
            objectStore.createIndex((Bson)new BasicDBObject("id", (Object)1), bg);
            objectStore.createIndex((Bson)new BasicDBObject("timestamp", (Object)1), bg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("creating index (%s) on %s", "obsId", "metadataObjectStore"));
        }
        MongoCollection metadata = db.getCollection("metadataObjectStore", DBObject.class);
        metadata.createIndex((Bson)new BasicDBObject("obsId", (Object)1), bg);
        log.info((Object)"objectStore indexes integrity completed");
    }
}

