/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.grid.process;

import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.grid.process.model.GridOrganization;
import eu.dnetlib.grid.process.utils.Datasource;
import eu.dnetlib.grid.process.utils.GridCleaner;
import eu.dnetlib.grid.process.utils.GridUtils;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

@SpringBootApplication
public class GridOrganizationsApplication
implements CommandLineRunner {
    private static final Datasource gridDs = new Datasource("10|openaire____::" + Hashing.md5((String)"grid"), "GRID - Global Research Identifier Database", "grid________");

    public static void main(String[] args) {
        SpringApplication.run(GridOrganizationsApplication.class, (String[])args);
    }

    public void run(String ... args) throws Exception {
        if (args.length == 1) {
            this.processFile(args[0]);
        } else {
            System.err.println();
            System.err.println("Usage: java -jar <JARFILE> <GridJsonFile>");
            System.err.println();
        }
    }

    protected void processFile(String jsonFile) throws Exception {
        GridCleaner cleaner = new GridCleaner();
        Map<String, String> parents = GridUtils.streamOrganizations((String)jsonFile).filter(Objects::nonNull).filter(o -> o.getStatus().equals("active")).collect(Collectors.toMap(GridOrganization::getId, GridUtils::findShortName));
        JsonFormat jsonFormat = new JsonFormat();
        GridUtils.streamOrganizations((String)jsonFile).filter(Objects::nonNull).filter(o -> o.getStatus().equals("active")).map(cleaner).map(org -> GridUtils.toProtos((GridOrganization)org, (Map)parents, (Datasource)gridDs)).flatMap(Collection::stream).map(arg_0 -> ((JsonFormat)jsonFormat).printToString(arg_0)).forEach(System.out::println);
    }
}

