/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.grid.process.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.OrganizationProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.grid.process.model.GridLabel;
import eu.dnetlib.grid.process.model.GridOrganization;
import eu.dnetlib.grid.process.model.GridRel;
import eu.dnetlib.grid.process.model.GridResponse;
import eu.dnetlib.grid.process.utils.Datasource;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class GridUtils {
    public static Stream<GridOrganization> streamOrganizations(String jsonFile) {
        try {
            return StreamSupport.stream(GridUtils.getOrganizations((InputStream)new FileInputStream(jsonFile)).spliterator(), false);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return Stream.empty();
        }
    }

    protected static Iterable<GridOrganization> getOrganizations(InputStream input) {
        try {
            return ((GridResponse)new ObjectMapper().readValue(input, GridResponse.class)).getInstitutes();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new ArrayList<GridOrganization>();
        }
    }

    public static List<OafProtos.Oaf> toProtos(GridOrganization org, Map<String, String> parents, Datasource ds) {
        String gridId = org.getId();
        String parent = GridUtils.findParentName((GridOrganization)org, parents);
        String mainName = GridUtils.applyPrefix((String)parent, (String)org.getName());
        String shortName = GridUtils.findShortName((GridOrganization)org);
        String mainOpenaireId = GridUtils.calculateOpenaireId((String)ds.getPrefix(), (String)gridId);
        Set alternativeNames = GridUtils.calculateAlternativeNames((GridOrganization)org);
        Map<String, String> orgNames = alternativeNames.stream().map(s -> GridUtils.applyPrefix((String)parent, (String)s)).collect(Collectors.toMap(s -> GridUtils.calculateOpenaireId((String)ds.getPrefix(), (String)gridId, (String)s), s -> s));
        orgNames.put(mainOpenaireId, mainName);
        FieldTypeProtos.Qualifier country = org.getAddresses().stream().map(addr -> FieldTypeProtos.Qualifier.newBuilder().setClassid(addr.getCountry_code()).setClassname(addr.getCountry()).setSchemeid("dnet:countries").setSchemename("dnet:countries")).filter(q -> StringUtils.isNotBlank((CharSequence)q.getClassid())).filter(q -> StringUtils.isNotBlank((CharSequence)q.getClassname())).map(q -> q.build()).findFirst().orElse(null);
        FieldTypeProtos.KeyValue collectedFrom = FieldTypeProtos.KeyValue.newBuilder().setKey(ds.getId()).setValue(ds.getName()).build();
        return orgNames.entrySet().stream().map(e -> GridUtils.toProtos((String)((String)e.getKey()), (String)gridId, (String)((String)e.getValue()), (String)shortName, (String)org.getLinks().stream().findFirst().orElse(""), (FieldTypeProtos.Qualifier)country, (Set)(((String)e.getKey()).equals(mainOpenaireId) ? alternativeNames : new HashSet()), orgNames.keySet(), (FieldTypeProtos.KeyValue)collectedFrom)).flatMap(l -> l.stream()).collect(Collectors.toList());
    }

    private static List<OafProtos.Oaf> toProtos(String openaireId, String gridId, String name, String shortName, String url, FieldTypeProtos.Qualifier country, Set<String> alternativeNames, Set<String> orgRels, FieldTypeProtos.KeyValue collectedFrom) {
        OafProtos.OafEntity.Builder entity = OafProtos.OafEntity.newBuilder().setId(openaireId).addPid(FieldTypeProtos.StructuredProperty.newBuilder().setValue(gridId).setQualifier(FieldTypeProtos.Qualifier.newBuilder().setClassid("grid").setClassname("grid").setSchemeid("dnet:pid_types").setSchemename("dnet:pid_types"))).addCollectedfrom(collectedFrom).setType(TypeProtos.Type.organization).setOrganization(OrganizationProtos.Organization.newBuilder().setMetadata(OrganizationProtos.Organization.Metadata.newBuilder().setLegalname(FieldTypeProtos.StringField.newBuilder().setValue(name)).setLegalshortname(FieldTypeProtos.StringField.newBuilder().setValue(shortName)).setWebsiteurl(FieldTypeProtos.StringField.newBuilder().setValue(url)).addAllAlternativeNames((Iterable)alternativeNames.stream().map(a -> FieldTypeProtos.StringField.newBuilder().setValue(a).build()).collect(Collectors.toList())).setCountry(country)));
        List<OafProtos.Oaf> oafs = orgRels.stream().filter(id -> !id.equals(openaireId)).map(id -> OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.relation).setLastupdatetimestamp(DateUtils.now()).setRel(OafProtos.OafRel.newBuilder().setSource(openaireId).setTarget(id).setRelType(RelTypeProtos.RelType.organizationOrganization).setSubRelType(RelTypeProtos.SubRelType.dedupSimilarity).setRelClass("isSimilarTo").setChild(false)).build()).collect(Collectors.toList());
        oafs.add(OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.entity).setLastupdatetimestamp(DateUtils.now()).setEntity(entity).setDataInfo(FieldTypeProtos.DataInfo.newBuilder().setTrust("0.90").setInferred(false).setProvenanceaction(FieldTypeProtos.Qualifier.newBuilder().setClassid("UNKNOWN").setClassname("UNKNOWN").setSchemeid("dnet:provenanceActions").setSchemename("dnet:provenanceActions"))).build());
        return oafs;
    }

    private static String calculateOpenaireId(String prefix, String gridId) {
        return String.format("20|%s::%s", prefix, Hashing.md5((String)gridId));
    }

    private static String calculateOpenaireId(String prefix, String gridId, String name) {
        return String.format("20|%s::%s", prefix, Hashing.md5((String)(gridId + " " + name)));
    }

    private static String applyPrefix(String parent, String simpleName) {
        return StringUtils.isBlank((CharSequence)parent) ? simpleName : parent + " - " + simpleName;
    }

    private static Set<String> calculateAlternativeNames(GridOrganization org) {
        Set<String> res = org.getLabels().stream().map(GridLabel::getLabel).collect(Collectors.toSet());
        res.addAll(org.getAcronyms());
        return res;
    }

    public static String findShortName(GridOrganization org) {
        return org.getAcronyms().stream().filter(StringUtils::isNotBlank).findFirst().orElse(org.getName());
    }

    private static String findParentName(GridOrganization org, Map<String, String> parents) {
        return org.getRelationships().stream().filter(r -> r.getType().equalsIgnoreCase("Parent")).map(GridRel::getId).map(parents::get).filter(StringUtils::isNotBlank).findFirst().orElse(null);
    }
}

