package eu.dnetlib.grid.process;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

import com.googlecode.protobuf.format.JsonFormat;

import eu.dnetlib.grid.process.model.GridOrganization;
import eu.dnetlib.grid.process.utils.Datasource;
import eu.dnetlib.grid.process.utils.GridCleaner;
import eu.dnetlib.grid.process.utils.GridUtils;
import eu.dnetlib.miscutils.functional.hash.Hashing;

@SpringBootApplication
public class GridOrganizationsApplication implements CommandLineRunner {

	private static final Datasource gridDs =
			new Datasource("10|openaire____::" + Hashing.md5("grid"), "GRID - Global Research Identifier Database", "grid________");

	public static void main(final String[] args) {
		SpringApplication.run(GridOrganizationsApplication.class, args);
	}

	@Override
	public void run(final String... args) throws Exception {

		if (args.length == 1) {
			processFile(args[0]);
		} else {
			System.err.println();
			System.err.println("Usage: java -jar <JARFILE> <GridJsonFile>");
			System.err.println();
		}
	}

	protected void processFile(final String jsonFile) throws Exception {
		final GridCleaner cleaner = new GridCleaner();

		final Map<String, String> parents = GridUtils.streamOrganizations(jsonFile)
				.filter(Objects::nonNull)
				.filter(o -> o.getStatus().equals("active"))
				.collect(Collectors.toMap(GridOrganization::getId, GridUtils::findShortName));

		final JsonFormat jsonFormat = new JsonFormat();

		GridUtils.streamOrganizations(jsonFile)
				.filter(Objects::nonNull)
				.filter(o -> o.getStatus().equals("active"))
				.map(cleaner)
				.map(org -> GridUtils.toProtos(org, parents, gridDs))
				.flatMap(List::stream)
				.map(jsonFormat::printToString)
				.forEach(System.out::println);

	}

}
