package eu.dnetlib.data.objectstore.modular.gridFS;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;

import com.mongodb.MongoOptions;

public class MongoGridFSOptionsFactory implements FactoryBean<MongoOptions> {

	private int connectionsPerHost;

	@Override
	public MongoOptions getObject() throws BeansException {
		MongoOptions opts = new MongoOptions();
		opts.connectionsPerHost = connectionsPerHost;
		return opts;
	}

	@Override
	public Class<MongoOptions> getObjectType() {
		return MongoOptions.class;
	}

	@Override
	public boolean isSingleton() {
		return false;
	}

	public int getConnectionsPerHost() {
		return connectionsPerHost;
	}

	public void setConnectionsPerHost(final int connectionsPerHost) {
		this.connectionsPerHost = connectionsPerHost;
	}

}
