/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.modular.gridFS;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import eu.dnetlib.data.objectstore.modular.gridFS.ObjectStoreFileUtility;
import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetAware;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.miscutils.collections.MappedCollection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GridFSObjectstoreResultSetListener
implements ResultSetListener,
ResultSetAware {
    private static final Log log = LogFactory.getLog(GridFSObjectstoreResultSetListener.class);
    private Long fromDate;
    private Long untilDate;
    private List<String> records;
    private String objectStoreID;
    private GridFS collection;
    private String baseURI;
    private int currentSize = -1;
    private DBCursor currentCursor;
    private long cursorPosition;

    public List<String> getResult(int from, int to) {
        log.debug((Object)String.format("ObjectStoreId :%s, from: %d, to: %d", this.objectStoreID, from, to));
        if (this.records != null) {
            ArrayList ids = Lists.newArrayList();
            for (int i = from; i < to; ++i) {
                ids.add(this.records.get(i));
            }
            QueryBuilder qBuilder = QueryBuilder.start((String)"metadata.id").in((Object)ids);
            DBObject q = qBuilder.get();
            List out = this.collection.find(q);
            return MappedCollection.listMap((Iterable)out, ObjectStoreFileUtility.asJSON(this.baseURI, this.objectStoreID));
        }
        if (this.fromDate != null && this.untilDate != null) {
            if (this.currentCursor == null || this.cursorPosition > (long)from) {
                this.createCurrentCursor();
            }
            while (this.cursorPosition < (long)from) {
                this.currentCursor.next();
                ++this.cursorPosition;
            }
            ArrayList<GridFSDBFile> out = new ArrayList<GridFSDBFile>();
            for (int i = from; i <= to; ++i) {
                if (!this.currentCursor.hasNext()) continue;
                out.add((GridFSDBFile)this.currentCursor.next());
                ++this.cursorPosition;
            }
            return MappedCollection.listMap(out, ObjectStoreFileUtility.asJSON(this.baseURI, this.objectStoreID));
        }
        throw new IllegalArgumentException("Missing parameters on Delivery must provide either from, to, or ObjectStoreIDs");
    }

    private void createCurrentCursor() {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"$gt", (Object)this.fromDate.doubleValue());
        query.put((Object)"$lt", (Object)this.untilDate.doubleValue());
        if (this.currentCursor != null) {
            this.currentCursor.close();
        }
        this.currentCursor = this.collection.getFileList((DBObject)new BasicDBObject("metadata.timestamp", (Object)query)).sort((DBObject)new BasicDBObject("_id", (Object)1));
        this.cursorPosition = 1L;
    }

    public int getSize() {
        if (this.currentSize == -1) {
            this.currentSize = this.calculateSize();
        }
        return this.currentSize - 1;
    }

    private int calculateSize() {
        if (this.records != null) {
            QueryBuilder qBuilder = QueryBuilder.start((String)"metadata.id").in(this.records);
            DBObject q = qBuilder.get();
            List out = this.collection.find(q);
            return out.size();
        }
        if (this.fromDate != null && this.untilDate != null) {
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"$gt", (Object)this.fromDate.doubleValue());
            query.put((Object)"$lt", (Object)this.untilDate.doubleValue());
            return this.collection.getFileList((DBObject)new BasicDBObject("metadata.timestamp", (Object)query)).size();
        }
        return 0;
    }

    public void setResultSet(ResultSet resultSet) {
        resultSet.close();
    }

    public Long getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Long fromdate) {
        this.fromDate = fromdate;
    }

    public Long getUntilDate() {
        return this.untilDate;
    }

    public void setUntilDate(Long untilDate) {
        this.untilDate = untilDate;
    }

    public List<String> getRecords() {
        return this.records;
    }

    public void setRecords(List<String> records) {
        this.records = records;
    }

    public GridFS getCollection() {
        return this.collection;
    }

    public void setCollection(GridFS collection) {
        this.collection = collection;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getObjectStoreID() {
        return this.objectStoreID;
    }

    public void setObjectStoreID(String objectStoreID) {
        this.objectStoreID = objectStoreID;
    }
}

