/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.hdfs;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.hadoop.hdfs.SequenceFileIterable;
import eu.dnetlib.miscutils.collections.Pair;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.Text;

public class SequenceFileUtils {
    public static final int NO_LIMIT = -1;
    private final PathFilter f = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().contains("part-r");
        }
    };

    public static Iterable<Pair<Text, Text>> read(Path path, final Configuration conf) throws IOException {
        return Iterables.concat((Iterable)Iterables.transform(new SequenceFileUtils().doRead(path, conf), (Function)new Function<Path, SequenceFileIterable<Text, Text>>(){

            public SequenceFileIterable<Text, Text> apply(Path path) {
                return new SequenceFileIterable<Text, Text>(path, conf);
            }
        }));
    }

    public static Iterable<Pair<Text, Text>> read(Path path, Configuration conf, int readMax) throws IOException {
        if (readMax != -1) {
            return Iterables.limit(SequenceFileUtils.read(path, conf), (int)readMax);
        }
        return SequenceFileUtils.read(path, conf);
    }

    private Iterable<Path> doRead(Path path, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        return Iterables.transform((Iterable)Lists.newArrayList((Object[])fs.listStatus(path, this.f)), (Function)new Function<FileStatus, Path>(){

            public Path apply(FileStatus fs) {
                Path path = fs.getPath();
                System.out.println("downloading xml files from path: " + path.toString());
                return path;
            }
        });
    }
}

