/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.config;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationFactory;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class ConfigurationEnumerator
implements BeanFactoryAware {
    private static final Log log = LogFactory.getLog(ConfigurationEnumerator.class);
    private ListableBeanFactory beanFactory;
    private final Function<ConfigurationFactory, Configuration> asConfiguration = new Function<ConfigurationFactory, Configuration>(){

        public Configuration apply(ConfigurationFactory factory) {
            return factory.getConfiguration();
        }
    };

    public Map<String, Configuration> getAll() {
        return Maps.transformValues((Map)this.beanFactory.getBeansOfType(ConfigurationFactory.class), this.asConfiguration);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public ListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public Configuration get(ClusterName name) {
        try {
            return (Configuration)this.beanFactory.getBean(name.toString(), Configuration.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            log.error((Object)("undefined bean: " + (Object)((Object)name)), (Throwable)e);
            return null;
        }
    }
}

