package eu.dnetlib.data.hadoop.config;

import java.util.Arrays;
import java.util.List;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

/**
 * Enumeration of the managed clusters.
 *
 * @author claudio
 *
 */
public enum ClusterName {
	DM, // Data Management
	DHP, //Dnet Hadoop Cluster
	IIS; // Information Inference Service(s)



	public static List<String> asStringList() {
		return Lists.newArrayList(Iterables.transform(asList(), new Function<ClusterName, String>() {

			@Override
			public String apply(final ClusterName clusterName) {
				return clusterName.toString();
			}
		}));
	}

	public static List<ClusterName> asList() {
		return Arrays.asList(ClusterName.values());
	}

}
