package eu.dnetlib.data.transform;

import java.io.StringReader;
import java.util.Map;
import java.util.Map.Entry;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;

public class XsltRowTransformerFactory {

	private static final Log log = LogFactory.getLog(XsltRowTransformerFactory.class); // NOPMD by marko on 11/24/08 5:02 PM

	public XsltRowTransformer getTransformer(final String xslt) {
		return doGetTransformer(xslt, null);
	}

	public XsltRowTransformer getTransformer(final String xslt, final Map<String, Object> params) {
		return doGetTransformer(xslt, params);
	}

	private XsltRowTransformer doGetTransformer(final String xslt, final Map<String, Object> params) {
		try {
			if ((xslt == null) || xslt.isEmpty()) return new XsltRowTransformer(null);

			final TransformerFactory factory = TransformerFactory.newInstance();

			if (log.isDebugEnabled()) {
				log.debug("using transformer factory: '" + factory.getClass().getCanonicalName() + "'");
			}

			final Transformer t = factory.newTransformer(new DocumentSource(new SAXReader().read(new StringReader(xslt))));
			if (!MapUtils.isEmpty(params)) {
				for (final Entry<String, Object> e : params.entrySet()) {
					log.debug(String.format("using xslt param: %s - %s", e.getKey(), e.getValue()));
					t.setParameter(e.getKey(), e.getValue());
				}
			}
			return new XsltRowTransformer(t);
		} catch (final Exception e) {
			throw new RuntimeException("Error generating transformer from xslt:\n" + xslt, e);
		}
	}

	public static XsltRowTransformer newInstance(final String xslt) {
		return new XsltRowTransformerFactory().getTransformer(xslt);
	}

	public static XsltRowTransformer newInstance(final String xslt, final Map<String, Object> params) {
		return new XsltRowTransformerFactory().getTransformer(xslt, params);
	}

}
