package eu.dnetlib.data.hadoop.utils;

import java.util.Map;
import java.util.Set;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import eu.dnetlib.data.hadoop.rmi.HadoopJobType;

public class JobProfile {

	private final Map<String, String> jobDefinition = Maps.newHashMap();
	private final Set<String> requiredParams = Sets.newHashSet();
	private ScanProperties scanProperties;

	private String name;

	private String description = "";

	private HadoopJobType jobType;

	public boolean isEmpty() {
		return getJobDefinition().isEmpty();
	}

	public Map<String, String> getJobDefinition() {
		return jobDefinition;
	}

	public Set<String> getRequiredParams() {
		return requiredParams;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public ScanProperties getScanProperties() {
		return scanProperties;
	}

	public void setScanProperties(ScanProperties scanProperties) {
		this.scanProperties = scanProperties;
	}

	public HadoopJobType getJobType() {
		return jobType;
	}

	public void setJobType(HadoopJobType jobType) {
		this.jobType = jobType;
	}

}
