/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.oozie;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.dnetlib.data.hadoop.action.JobCompletion;
import eu.dnetlib.data.hadoop.action.JobMonitor;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;

public class OozieJobMonitor
extends JobMonitor {
    private static final Log log = LogFactory.getLog(JobMonitor.class);
    private final OozieClient oozieClient;
    private final String jobId;
    public static final String ACTION_TYPE_SUBWORKFLOW = "sub-workflow";
    private Set<String> workflowActions = Sets.newHashSet();

    public OozieJobMonitor(OozieClient oozieClient, String jobId, JobCompletion callback) {
        super(callback);
        this.oozieClient = oozieClient;
        this.jobId = jobId;
    }

    public OozieJobMonitor(OozieClient oozieClient, String jobId, JobCompletion callback, Set<String> workflowActions) {
        super(callback);
        this.oozieClient = oozieClient;
        this.jobId = jobId;
        this.workflowActions = workflowActions;
    }

    @Override
    public void run() {
        try {
            log.info((Object)("waiting for oozie job completion: " + this.getHadoopId()));
            WorkflowJob.Status status = this.doGetStatus();
            while (status.equals((Object)WorkflowJob.Status.RUNNING)) {
                Thread.sleep(10000L);
                WorkflowJob.Status currentStatus = this.doGetStatus();
                if (status.equals((Object)currentStatus)) continue;
                status = currentStatus;
                this.lastActivity = new Date(System.currentTimeMillis());
            }
            log.debug((Object)("job " + this.jobId + " finihsed with status: " + status));
            if (status == WorkflowJob.Status.SUCCEEDED) {
                Properties report = OozieJobMonitor.getReport(this.getOozieClient(), this.getHadoopId(), this.workflowActions);
                if (report != null) {
                    HashMap map = Maps.newHashMap();
                    report.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put(k.toString(), v.toString())));
                    this.getCallback().done(map);
                } else {
                    this.getCallback().done(new HashMap<String, String>());
                }
            } else {
                String msg = "hadoop job: " + this.getHadoopId() + " failed with status: " + this.getStatus() + ", oozie log:\n " + this.getOozieClient().getJobLog(this.getHadoopId()) + "\n\n";
                this.getCallback().failed(msg, new HadoopServiceException(msg));
            }
        }
        catch (Throwable e) {
            this.getCallback().failed(this.getHadoopId(), e);
        }
    }

    private static Properties getReport(OozieClient oozieClient, String oozieJobId, Set<String> workflowActions) throws OozieClientException, IOException {
        WorkflowJob oozieJob = oozieClient.getJobInfo(oozieJobId);
        for (WorkflowAction currentAction : oozieJob.getActions()) {
            log.debug((Object)String.format("looking for workflo actions to report, current: '%s'", currentAction.getName()));
            if (!workflowActions.contains(currentAction.getName())) continue;
            if (ACTION_TYPE_SUBWORKFLOW.equals(currentAction.getType())) {
                Properties subworkflowProperties = OozieJobMonitor.getReport(oozieClient, currentAction.getExternalId(), workflowActions);
                if (subworkflowProperties == null) continue;
                return subworkflowProperties;
            }
            if (!StringUtils.isNotBlank((String)currentAction.getData())) continue;
            Properties properties = new Properties();
            properties.load(IOUtils.toInputStream((String)currentAction.getData()));
            return properties;
        }
        return null;
    }

    @Override
    public String getHadoopId() {
        return this.jobId;
    }

    public OozieClient getOozieClient() {
        return this.oozieClient;
    }

    @Override
    public String getStatus() {
        try {
            return this.doGetStatus().toString();
        }
        catch (OozieClientException e) {
            log.error((Object)"error accessing job status", (Throwable)e);
            return "UNKNOWN";
        }
    }

    private WorkflowJob.Status doGetStatus() throws OozieClientException {
        return this.getOozieClient().getJobInfo(this.getHadoopId()).getStatus();
    }

    @Override
    public Date getLastActivity() {
        return this.lastActivity;
    }

    @Override
    public Date getStartTime() throws HadoopServiceException {
        try {
            return this.getOozieClient().getJobInfo(this.getHadoopId()).getStartTime();
        }
        catch (OozieClientException e) {
            throw new HadoopServiceException("unable to read job start time", (Throwable)e);
        }
    }

    @Override
    public String getTrackerUrl() {
        return this.getOozieClient().getOozieUrl();
    }

    @Override
    public void kill() {
        try {
            this.getOozieClient().kill(this.getHadoopId());
        }
        catch (OozieClientException e) {
            log.error((Object)("unable to kill job: " + this.getHadoopId()), (Throwable)e);
        }
    }
}

