/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.dnetlib.data.hadoop.HadoopClientMap;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.data.hadoop.rmi.hbase.Column;
import eu.dnetlib.data.hadoop.rmi.hbase.HBaseRowDescriptor;
import eu.dnetlib.data.hadoop.rmi.hbase.schema.HBaseTableDescriptor;
import eu.dnetlib.data.hadoop.rmi.hbase.schema.HBaseTableRegionInfo;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class HadoopServiceCore {
    private static final Log log = LogFactory.getLog(HadoopServiceCore.class);
    @Autowired
    protected ConfigurationEnumerator configurationEnumerator;
    @Autowired
    private HadoopClientMap clients;
    private int maxVersions;

    public List<String> listTables(ClusterName clusterName) throws IOException, HadoopServiceException {
        HBaseAdmin admin = this.getHBaseAdmin(clusterName);
        return Arrays.asList(admin.listTables()).stream().map(HTableDescriptor::getNameAsString).collect(Collectors.toList());
    }

    private HBaseAdmin getHBaseAdmin(ClusterName clusterName) throws HadoopServiceException {
        HBaseAdmin admin = this.clients.getHbaseAdmin(clusterName);
        if (admin == null) {
            throw new HadoopServiceException(String.format("HBase admin not available for cluster: '%s'", clusterName.toString()));
        }
        return admin;
    }

    public String getHBaseTableDescriptor(ClusterName clusterName, String tableName) throws HadoopServiceException, IOException {
        HBaseAdmin admin = this.clients.getHbaseAdmin(clusterName);
        if (StringUtils.isBlank((String)tableName)) {
            throw new HadoopServiceException("Table name cannot be empty or null");
        }
        if (admin == null) {
            throw new HadoopServiceException(String.format("HBase admin not available for cluster: '%s'", clusterName.toString()));
        }
        List tableRegions = admin.getTableRegions(tableName.getBytes());
        HTableDescriptor desc = admin.getTableDescriptor(tableName.getBytes());
        HashSet columns = Sets.newHashSet();
        for (HColumnDescriptor hColDesc : Arrays.asList(desc.getColumnFamilies())) {
            columns.add(hColDesc.getNameAsString());
        }
        HBaseTableDescriptor htDescriptor = new HBaseTableDescriptor();
        htDescriptor.setColumns((Set)columns);
        ArrayList regions = Lists.newArrayList();
        for (HRegionInfo info : tableRegions) {
            regions.add(new HBaseTableRegionInfo(new String(info.getStartKey()), new String(info.getEndKey())));
        }
        htDescriptor.setRegions((List)regions);
        if (log.isDebugEnabled()) {
            log.info((Object)("got configuration for table '" + tableName + "': " + htDescriptor.toString()));
        }
        return htDescriptor.toString();
    }

    public List<String> describeTable(ClusterName clusterName, String table) throws IOException, HadoopServiceException {
        HBaseAdmin admin = this.getHBaseAdmin(clusterName);
        HTableDescriptor desc = admin.getTableDescriptor(table.getBytes());
        return desc.getFamilies().stream().map(d -> d.getNameAsString()).collect(Collectors.toList());
    }

    public void truncateTable(ClusterName clusterName, String table) throws IOException, HadoopServiceException {
        HBaseAdmin admin = this.getHBaseAdmin(clusterName);
        if (!admin.tableExists(table)) {
            throw new IllegalStateException("cannot truncate unexisting table");
        }
        HTableDescriptor desc = admin.getTableDescriptor(table.getBytes());
        log.info((Object)("disabling table: " + table));
        admin.disableTable(table);
        log.info((Object)("deleting table: " + table));
        admin.deleteTable(table);
        log.info((Object)("creating table: " + table));
        admin.createTable(desc);
    }

    public boolean existTable(ClusterName clusterName, String table) throws IOException, HadoopServiceException {
        HBaseAdmin admin = this.getHBaseAdmin(clusterName);
        return admin.tableExists(table);
    }

    public void dropTable(ClusterName clusterName, String table) throws IOException, HadoopServiceException {
        HBaseAdmin admin = this.getHBaseAdmin(clusterName);
        if (!admin.tableExists(table)) {
            throw new IllegalStateException("cannot drop unexisting table: '" + table + "'");
        }
        log.info((Object)("disabling table: " + table));
        admin.disableTable(table);
        log.info((Object)("deleting table: " + table));
        admin.deleteTable(table);
    }

    public void createTable(ClusterName clusterName, String table, String tableConfiguration) throws IOException, HadoopServiceException {
        HBaseAdmin admin = this.getHBaseAdmin(clusterName);
        if (admin.tableExists(table)) {
            throw new IllegalStateException("table already exists");
        }
        if (StringUtils.isBlank((String)tableConfiguration)) {
            throw new HadoopServiceException("empty table configuration");
        }
        HBaseTableDescriptor tableConf = HBaseTableDescriptor.fromJSON((String)tableConfiguration);
        this.doCreateTable(clusterName, table, tableConf.getColumns(), tableConf.getRegions());
    }

    public void createTable(ClusterName clusterName, String table, Set<String> columns) throws IOException, HadoopServiceException {
        HBaseAdmin admin = this.getHBaseAdmin(clusterName);
        if (admin.tableExists(table)) {
            throw new IllegalStateException("table already exists");
        }
        this.doCreateTable(clusterName, table, columns, null);
    }

    public void doCreateTable(ClusterName clusterName, String table, Set<String> columns, List<HBaseTableRegionInfo> regions) throws IOException, HadoopServiceException {
        HBaseAdmin admin = this.getHBaseAdmin(clusterName);
        if (admin.tableExists(table)) {
            throw new IllegalStateException("table already exists");
        }
        HTableDescriptor desc = new HTableDescriptor(table);
        for (String column : columns) {
            HColumnDescriptor hds = new HColumnDescriptor(column);
            hds.setMaxVersions(this.getMaxVersions());
            desc.addFamily(hds);
        }
        log.info((Object)("creating hbase table: " + table));
        if (regions != null && !regions.isEmpty()) {
            log.debug((Object)String.format("create using %s regions: %s", regions.size(), regions));
            admin.createTable(desc, this.getSplitKeys(regions));
        } else {
            admin.createTable(desc);
        }
        log.info((Object)("created hbase table: [" + table + "]"));
        log.debug((Object)("descriptor: [" + desc.toString() + "]"));
    }

    private byte[][] getSplitKeys(List<HBaseTableRegionInfo> regions) {
        byte[][] splits = new byte[regions.size() - 1][];
        for (int i = 0; i < regions.size() - 1; ++i) {
            splits[i] = regions.get(i).getEndKey().getBytes();
        }
        return splits;
    }

    public void ensureTable(ClusterName clusterName, String table, Set<String> columns) throws IOException, HadoopServiceException {
        HBaseAdmin admin = this.getHBaseAdmin(clusterName);
        if (!admin.tableExists(table)) {
            this.createTable(clusterName, table, columns);
        } else {
            HTableDescriptor desc = admin.getTableDescriptor(Bytes.toBytes((String)table));
            Set foundColumns = desc.getFamilies().stream().map(d -> d.getNameAsString()).collect(Collectors.toCollection(HashSet::new));
            log.info((Object)("ensuring columns on table " + table + ": " + columns));
            Sets.SetView missingColumns = Sets.difference(columns, (Set)foundColumns);
            if (!missingColumns.isEmpty()) {
                if (admin.isTableEnabled(table)) {
                    admin.disableTable(table);
                }
                for (String column : missingColumns) {
                    log.info((Object)("hbase table: '" + table + "', adding column: " + column));
                    admin.addColumn(table, new HColumnDescriptor(column));
                }
                admin.enableTable(table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOnHBase(ClusterName clusterName, String tableName, List<Put> puts) throws IOException {
        Configuration conf = this.configurationEnumerator.get(clusterName);
        HTable table = new HTable(conf, tableName);
        try {
            table.put(puts);
        }
        finally {
            table.flushCommits();
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromHBase(ClusterName clusterName, String tableName, List<Delete> deletes) throws IOException {
        Configuration conf = this.configurationEnumerator.get(clusterName);
        HTable table = new HTable(conf, tableName);
        try {
            table.delete(deletes);
        }
        finally {
            table.flushCommits();
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteColumnsFromHBase(ClusterName clusterName, String tableName, List<HBaseRowDescriptor> columns) throws IOException {
        Configuration conf = this.configurationEnumerator.get(clusterName);
        HTable table = new HTable(conf, tableName);
        try {
            for (HBaseRowDescriptor desc : columns) {
                Delete d = new Delete(Bytes.toBytes((String)desc.getRowKey()));
                d.setWriteToWAL(true);
                for (Column c : desc.getColumns()) {
                    for (String qualifier : c.getQualifier()) {
                        log.info((Object)String.format("delete from row '%s' cf '%s:%s'", desc.getRowKey(), c.getFamily(), qualifier));
                        d.deleteColumns(Bytes.toBytes((String)c.getFamily()), Bytes.toBytes((String)qualifier));
                    }
                }
                table.delete(d);
            }
        }
        finally {
            table.flushCommits();
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getRow(ClusterName clusterName, String tableName, byte[] id) throws IOException {
        Configuration conf = this.configurationEnumerator.get(clusterName);
        try (HTable table = new HTable(conf, tableName);){
            Result result = table.get(new Get(id));
            return result;
        }
    }

    public Map<String, HBaseRowDescriptor> describeRows(ClusterName clusterName, String tableName, List<String> rowKeys) throws IOException {
        HashMap map = Maps.newHashMap();
        for (String rowKey : rowKeys) {
            map.put(rowKey, this.describeRow(clusterName, tableName, rowKey));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HBaseRowDescriptor describeRow(ClusterName clusterName, String tableName, String rowKey) throws IOException {
        Configuration conf = this.configurationEnumerator.get(clusterName);
        HBaseRowDescriptor desc = new HBaseRowDescriptor();
        try (HTable table = new HTable(conf, tableName);){
            Result r = table.get(new Get(Bytes.toBytes((String)rowKey)));
            if (r.isEmpty()) {
                HBaseRowDescriptor hBaseRowDescriptor = desc;
                return hBaseRowDescriptor;
            }
            ArrayList columns = Lists.newArrayList();
            for (Map.Entry e : r.getNoVersionMap().entrySet()) {
                Set qualifiers = ((NavigableMap)e.getValue()).keySet();
                String family = new String((byte[])e.getKey());
                Column col = new Column(family);
                for (byte[] q : qualifiers) {
                    String qs = new String(q);
                    col.getQualifier().add(qs);
                }
                columns.add(col);
            }
            desc.setColumns((List)columns);
            desc.setRowKey(rowKey);
            HBaseRowDescriptor hBaseRowDescriptor = desc;
            return hBaseRowDescriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Result> getRows(ClusterName clusterName, String tableName, Scan scan) throws IOException {
        Configuration conf = this.configurationEnumerator.get(clusterName);
        try (HTable table = new HTable(conf, tableName);){
            ArrayList arrayList;
            ResultScanner rs = table.getScanner(scan);
            try {
                arrayList = Lists.newArrayList((Iterator)rs.iterator());
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return arrayList;
        }
    }

    public boolean deleteFromHdfs(ClusterName clusterName, String path) throws HadoopServiceException {
        if (StringUtils.isBlank((String)path)) {
            throw new HadoopServiceException("Cannot deleteFromHBase an empty HDFS path.");
        }
        Configuration conf = this.configurationEnumerator.get(clusterName);
        try {
            FileSystem hdfs = FileSystem.get((Configuration)conf);
            Path absolutePath = new Path(URI.create(conf.get("fs.defaultFS") + path));
            if (hdfs.exists(absolutePath)) {
                log.debug((Object)("deleteFromHBase path: " + absolutePath.toString()));
                hdfs.delete(absolutePath, true);
                log.info((Object)("deleted path: " + absolutePath.toString()));
                return true;
            }
            log.warn((Object)("cannot deleteFromHBase unexisting path: " + absolutePath.toString()));
            return false;
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public boolean createHdfsDir(ClusterName clusterName, String path, boolean force) throws HadoopServiceException {
        if (StringUtils.isBlank((String)path)) {
            throw new HadoopServiceException("Cannot create an empty HDFS path.");
        }
        Configuration conf = this.configurationEnumerator.get(clusterName);
        try {
            FileSystem hdfs = FileSystem.get((Configuration)conf);
            Path absolutePath = new Path(URI.create(conf.get("fs.defaultFS") + path));
            if (!hdfs.exists(absolutePath)) {
                hdfs.mkdirs(absolutePath);
                log.info((Object)("created path: " + absolutePath.toString()));
                return true;
            }
            if (force) {
                log.info((Object)String.format("found directory '%s', force delete it", absolutePath.toString()));
                hdfs.delete(absolutePath, true);
                hdfs.mkdirs(absolutePath);
                log.info((Object)("created path: " + absolutePath.toString()));
                return true;
            }
            log.info((Object)String.format("directory already exists: '%s', nothing to do", absolutePath.toString()));
            return false;
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public boolean existHdfsPath(ClusterName clusterName, String path) throws HadoopServiceException {
        if (StringUtils.isBlank((String)path)) {
            throw new HadoopServiceException("invalid empty path");
        }
        Configuration conf = this.configurationEnumerator.get(clusterName);
        try {
            FileSystem hdfs = FileSystem.get((Configuration)conf);
            Path absolutePath = new Path(URI.create(conf.get("fs.defaultFS") + path));
            return hdfs.exists(absolutePath);
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public Configuration getClusterConiguration(ClusterName clusterName) {
        return this.configurationEnumerator.get(clusterName);
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    @Required
    public void setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
    }

    public HadoopClientMap getClients() {
        return this.clients;
    }
}

