/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop;

import eu.dnetlib.data.hadoop.action.JobMonitor;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopJobDescriptor;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.data.hadoop.utils.JobProfile;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HadoopJob {
    private static final Log log = LogFactory.getLog(HadoopJob.class);
    private final Executor executor = Executors.newSingleThreadExecutor();
    private final JobMonitor jobMonitor;
    private final JobProfile jobProfile;
    private final ClusterName clusterName;
    private final String id;

    public static HadoopJob newInstance(String id, ClusterName clusterName, JobProfile profile, JobMonitor jobMonitor) {
        return new HadoopJob(id, clusterName, profile, jobMonitor);
    }

    private HadoopJob(String id, ClusterName clusterName, JobProfile jobProfile, JobMonitor jobMonitor) {
        this.id = id;
        this.clusterName = clusterName;
        this.jobProfile = jobProfile;
        this.jobMonitor = jobMonitor;
    }

    public void startMonitor() {
        log.info((Object)("start monitoring for job: " + this.getId()));
        this.executor.execute(this.jobMonitor);
    }

    public String getId() {
        return this.id;
    }

    public String getHadoopId() {
        return this.getJobMonitor().getHadoopId();
    }

    public JobMonitor getJobMonitor() {
        return this.jobMonitor;
    }

    public Status getStatus() {
        return Status.valueOf(this.getJobMonitor().getStatus());
    }

    public boolean isComplete() {
        Status status = this.getStatus();
        return status.equals((Object)Status.SUCCEEDED) || status.equals((Object)Status.FAILED) || status.equals((Object)Status.KILLED);
    }

    public Date getStartTime() throws HadoopServiceException {
        return this.jobMonitor.getStartTime();
    }

    public Date getLastActivity() {
        return this.jobMonitor.getLastActivity();
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public JobProfile getJobProfile() {
        return this.jobProfile;
    }

    public HadoopJobDescriptor asDescriptor() throws HadoopServiceException {
        return new HadoopJobDescriptor(this.getJobProfile().getName(), this.getJobProfile().getDescription(), this.getId(), this.getStatus().toString(), this.getStartTime().toString(), this.getLastActivity().toString(), this.getJobMonitor().getHadoopId(), this.getJobMonitor().getTrackerUrl());
    }

    public static enum Status {
        PREP,
        RUNNING,
        SUCCEEDED,
        KILLED,
        FAILED,
        SUSPENDED;

    }
}

