/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop;

import eu.dnetlib.data.hadoop.ISClient;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractHadoopClient {
    private static final Log log = LogFactory.getLog(AbstractHadoopClient.class);
    @Autowired
    private ISClient isClient;
    @Autowired
    protected ConfigurationEnumerator configurationEnumerator;

    protected void setHadoopUser() throws HadoopServiceException {
        this.setHadoopUser(this.getDefaultUser());
    }

    private String getDefaultUser() throws HadoopServiceException {
        try {
            return this.isClient.queryForServiceProperty("default.hadoop.user");
        }
        catch (ISLookUpException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    protected void setHadoopUser(String userName) {
        log.info((Object)("setting HADOOP_USER_NAME as " + userName));
        System.setProperty("HADOOP_USER_NAME", userName);
    }
}

