package eu.dnetlib.data.hadoop;

import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractHadoopClient {

	private static final Log log = LogFactory.getLog(AbstractHadoopClient.class);

	@Autowired
	private ISClient isClient;

	@Autowired
	protected ConfigurationEnumerator configurationEnumerator;

	protected void setHadoopUser() throws HadoopServiceException {
		setHadoopUser(getDefaultUser());
	}

	private String getDefaultUser() throws HadoopServiceException {
		try {
			return isClient.queryForServiceProperty("default.hadoop.user");
		} catch (ISLookUpException e) {
			throw new HadoopServiceException(e);
		}
	}

	protected void setHadoopUser(final String userName) {
		log.info("setting HADOOP_USER_NAME as " + userName);
		System.setProperty("HADOOP_USER_NAME", userName);
	}

}
