package eu.dnetlib.data.hadoop.utils;

import eu.dnetlib.data.hadoop.HadoopJob;
import eu.dnetlib.data.hadoop.rmi.HadoopJobDescriptor;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HadoopUtils {

	private static final Log log = LogFactory.getLog(HadoopUtils.class);

	public static java.util.function.Function<HadoopJob, HadoopJobDescriptor> asDescriptor() {
		return d -> {
			try {
				return d.asDescriptor();
			} catch (HadoopServiceException e) {
				log.warn(e);
				return null;
			}
		};
	}

}
