/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.utils;

import eu.dnetlib.data.hadoop.utils.ScanProperties;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.util.Base64;
import org.dom4j.Document;
import org.dom4j.Node;

public class ScanFactory {
    private static final Log log = LogFactory.getLog(ScanFactory.class);

    public static String getScan(ScanProperties scanProperties) throws IOException {
        Scan scan = new Scan();
        scan.setCaching(scanProperties.getCaching());
        scan.setCacheBlocks(false);
        scan.setFilter((Filter)scanProperties.getFilterList());
        for (String family : scanProperties.getFamilies()) {
            scan.addFamily(family.getBytes());
        }
        log.debug((Object)"serializing scan");
        return ScanFactory.convertScanToString(scan);
    }

    public static ScanProperties parseScanProperties(Document doc, Map<String, String> bbParams) {
        Node node;
        log.debug((Object)"setting job scanner");
        ScanProperties scanProperties = new ScanProperties(doc.valueOf("//FILTERS/@operator"));
        String caching = doc.valueOf("//SCAN/@caching");
        if (!StringUtils.isBlank((String)caching)) {
            log.info((Object)("overriding default scan caching with: " + caching));
            scanProperties.setCaching(Integer.valueOf(caching));
        }
        for (Object o : doc.selectNodes("//SCAN/FAMILIES/FAMILY")) {
            node = (Node)o;
            String value = node.valueOf("./@value");
            if (value == null || value.isEmpty()) {
                value = bbParams.get(node.valueOf("./@param"));
            }
            log.debug((Object)("scanner family value: " + value));
            scanProperties.getFamilies().add(value);
        }
        for (Object o : doc.selectNodes("//SCAN/FILTERS/FILTER")) {
            node = (Node)o;
            String filterType = node.valueOf("./@type");
            String value = node.valueOf("./@value");
            if (value == null || value.isEmpty()) {
                value = bbParams.get(node.valueOf("./@param"));
            }
            if (!filterType.equals("prefix")) continue;
            log.debug((Object)("scanner prefix filter, value: " + value));
            scanProperties.getFilterList().addFilter((Filter)new PrefixFilter(value.getBytes()));
        }
        return scanProperties;
    }

    private static String convertScanToString(Scan scan) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(out);
        scan.write((DataOutput)dos);
        return Base64.encodeBytes((byte[])out.toByteArray());
    }
}

