/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.hbase.HBaseAdminFactory;
import eu.dnetlib.data.hadoop.mapred.JobClientFactory;
import eu.dnetlib.data.hadoop.oozie.OozieClientFactory;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.mapred.JobClient;
import org.apache.oozie.client.OozieClient;
import org.springframework.beans.factory.annotation.Required;

public class HadoopClientMap {
    private static final Log log = LogFactory.getLog(HadoopClientMap.class);
    private JobClientFactory jobClientFactory;
    private OozieClientFactory oozieClientFactory;
    private HBaseAdminFactory hbaseAdminFactory;
    private Map<String, Map<String, String>> enabledClients = Maps.newHashMap();

    public boolean isMapreduceAvailable(ClusterName name) {
        return this.isClientAvailable(name, "mapred");
    }

    public boolean isOozieAvailable(ClusterName name) {
        return this.isClientAvailable(name, "oozie");
    }

    public boolean isHbaseAvailable(ClusterName name) {
        return this.isClientAvailable(name, "hbase");
    }

    private boolean isClientAvailable(ClusterName name, String clientName) {
        String clusterName = name.toString();
        return this.enabledClients.containsKey(clusterName) && "true".equals(this.enabledClients.get(clusterName).get(clientName));
    }

    public JobClient getJtClient(ClusterName clusterName, String username) throws HadoopServiceException, IOException {
        if (!this.isMapreduceAvailable(clusterName)) {
            throw new HadoopServiceException("jobtracker is not available for cluster " + clusterName.toString());
        }
        return this.getJobClientFactory().newInstance(clusterName, username);
    }

    public JobClient getJtClient(ClusterName clusterName) throws HadoopServiceException, IOException {
        if (!this.isMapreduceAvailable(clusterName)) {
            throw new HadoopServiceException("jobtracker is not available for cluster " + clusterName.toString());
        }
        return this.getJobClientFactory().newInstance(clusterName);
    }

    public OozieClient getOozieClient(ClusterName name) throws HadoopServiceException {
        if (!this.isOozieAvailable(name)) {
            throw new HadoopServiceException("oozie is not available for cluster " + name.toString());
        }
        return this.getOozieClientFactory().newInstance(name);
    }

    public HBaseAdmin getHbaseAdmin(ClusterName name) throws HadoopServiceException {
        if (!this.isHbaseAvailable(name)) {
            throw new HadoopServiceException("hbase is not available for cluster " + name.toString());
        }
        return this.getHbaseAdminFactory().newInstance(name);
    }

    public String getEnabledClients() {
        return new Gson().toJson(this.enabledClients);
    }

    @Required
    public void setEnabledClients(String enabledClients) {
        this.enabledClients = (Map)new Gson().fromJson(enabledClients, Map.class);
    }

    public JobClientFactory getJobClientFactory() {
        return this.jobClientFactory;
    }

    @Required
    public void setJobClientFactory(JobClientFactory jobClientFactory) {
        this.jobClientFactory = jobClientFactory;
    }

    public OozieClientFactory getOozieClientFactory() {
        return this.oozieClientFactory;
    }

    @Required
    public void setOozieClientFactory(OozieClientFactory oozieClientFactory) {
        this.oozieClientFactory = oozieClientFactory;
    }

    public HBaseAdminFactory getHbaseAdminFactory() {
        return this.hbaseAdminFactory;
    }

    @Required
    public void setHbaseAdminFactory(HBaseAdminFactory hbaseAdminFactory) {
        this.hbaseAdminFactory = hbaseAdminFactory;
    }
}

