/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import eu.dnetlib.data.hadoop.HadoopJob;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopJobDescriptor;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.data.hadoop.utils.HadoopUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class JobRegistry {
    private static final Log log = LogFactory.getLog(JobRegistry.class);
    private int maxJobs;
    private final BiMap<String, HadoopJob> jobs = HashBiMap.create();

    public String registerJob(HadoopJob hadoopJob) throws HadoopServiceException {
        if (this.jobs.containsValue((Object)hadoopJob)) {
            return (String)this.jobs.inverse().get((Object)hadoopJob);
        }
        if (this.jobs.size() > this.getMaxJobs()) {
            this.removeOldestProcess();
        }
        this.jobs.put((Object)hadoopJob.getId(), (Object)hadoopJob);
        log.info((Object)("Registered hadoop job " + hadoopJob.getId()));
        hadoopJob.startMonitor();
        return hadoopJob.getId();
    }

    public HadoopJob.Status getJobStatus(String id) {
        return this.findJob(id).getStatus();
    }

    public HadoopJob findJob(String id) {
        return (HadoopJob)this.jobs.get((Object)id);
    }

    public void unregisterJob(String id) throws HadoopServiceException {
        if (!this.jobs.containsKey((Object)id)) {
            throw new HadoopServiceException("unable to unregister job, could not find jobId in registry: " + id);
        }
        log.info((Object)("unregistering job: " + id));
        ((HadoopJob)this.jobs.get((Object)id)).getJobMonitor().kill();
        this.jobs.remove((Object)id);
    }

    private void removeOldestProcess() throws HadoopServiceException {
        Date oldDate = new Date();
        String oldId = null;
        for (Map.Entry e : this.jobs.entrySet()) {
            Date date;
            HadoopJob hadoopJob = (HadoopJob)e.getValue();
            if (!hadoopJob.isComplete() || !(date = hadoopJob.getLastActivity()).before(oldDate)) continue;
            oldDate = date;
            oldId = (String)e.getKey();
        }
        if (oldId != null) {
            this.unregisterJob(oldId);
        }
    }

    public List<HadoopJobDescriptor> listJobs(ClusterName clusterName) {
        return this.jobs.values().stream().filter(j -> clusterName.equals((Object)j.getClusterName())).map(HadoopUtils.asDescriptor()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Required
    public void setMaxJobs(int maxJobs) {
        this.maxJobs = maxJobs;
    }

    public int getMaxJobs() {
        return this.maxJobs;
    }
}

