/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.action;

import eu.dnetlib.data.hadoop.action.AbstractHadoopAction;
import eu.dnetlib.data.hadoop.action.SequenceFileFeeder;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ImportEprHdfsAction
extends AbstractHadoopAction {
    private static final Log log = LogFactory.getLog(ImportEprHdfsAction.class);
    private SequenceFileFeeder sequenceFileFeeder;

    @Override
    public void executeAsync(BlackboardServerHandler handler, BlackboardJob job) throws HadoopServiceException {
        String epr = DnetXsltFunctions.decodeBase64((String)((String)job.getParameters().get("input_epr")));
        ClusterName clusterName = ClusterName.valueOf((String)((String)job.getParameters().get("cluster")));
        String path = (String)job.getParameters().get("path");
        log.info((Object)String.format("Starting import in hdfs sequence file '%s', cluster '%s', epr '%s...", path, clusterName.toString(), StringUtils.substring((String)epr, (int)0, (int)20)));
        try {
            Integer count = this.getSequenceFileFeeder().feed(epr, clusterName, path);
            if (count != null) {
                log.info((Object)"Import completed successfully");
                job.getParameters().put("count", String.valueOf(count));
            }
            handler.done(job);
        }
        catch (IOException e) {
            throw new HadoopServiceException("Import failed", (Throwable)e);
        }
    }

    public SequenceFileFeeder getSequenceFileFeeder() {
        return this.sequenceFileFeeder;
    }

    @Required
    public void setSequenceFileFeeder(SequenceFileFeeder sequenceFileFeeder) {
        this.sequenceFileFeeder = sequenceFileFeeder;
    }
}

