/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.action;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import eu.dnetlib.data.hadoop.HadoopJob;
import eu.dnetlib.data.hadoop.action.AbstractSubmitAction;
import eu.dnetlib.data.hadoop.action.JobCompletion;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.oozie.OozieJobMonitor;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.data.hadoop.utils.JobProfile;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;

public class SubmitOozieJobAction
extends AbstractSubmitAction {
    private static final Log log = LogFactory.getLog(SubmitOozieJobAction.class);
    public static final String OOZIE_REPORT_ACTIONS = "oozie.report.actions.csv";

    @Override
    public void submit(JobCompletion callback, BlackboardJob bbJob, String jobName, JobProfile jobProfile) throws HadoopServiceException {
        ClusterName clusterName = ClusterName.valueOf((String)((String)bbJob.getParameters().get("cluster")));
        try {
            Properties jobConf = this.prepareJob(this.getConf(clusterName), jobName, jobProfile, bbJob.getParameters());
            log.debug((Object)("oozie job configuration:\n" + jobConf));
            if (!this.hadoopClientMap.isOozieAvailable(clusterName)) {
                throw new HadoopServiceException("oozie not available for cluster: " + clusterName.toString());
            }
            this.logJobDetails(jobConf);
            OozieClient oozieClient = this.hadoopClientMap.getOozieClient(clusterName);
            String internalId = oozieClient.run(jobConf);
            String jobId = this.newJobId(clusterName, internalId);
            this.jobRegistry.registerJob(HadoopJob.newInstance(jobId, clusterName, jobProfile, new OozieJobMonitor(oozieClient, internalId, callback, this.getWorkflowActions(bbJob))));
        }
        catch (OozieClientException e) {
            throw new HadoopServiceException("error executing hadoop job: " + jobName, (Throwable)e);
        }
    }

    private Set<String> getWorkflowActions(BlackboardJob bbJob) {
        String actions = (String)bbJob.getParameters().get(OOZIE_REPORT_ACTIONS);
        if (StringUtils.isNotBlank((String)actions)) {
            return Sets.newHashSet((Iterable)Splitter.on((String)",").split((CharSequence)actions));
        }
        return Sets.newHashSet();
    }

    private Properties prepareJob(Configuration configuration, String jobName, JobProfile jobProfile, Map<String, String> parameters) {
        log.info((Object)("creating job: " + jobName));
        Properties p = new Properties();
        this.merge(p, (Iterable<Map.Entry<String, String>>)configuration);
        this.merge(p, jobProfile.getJobDefinition().entrySet());
        this.merge(p, parameters.entrySet());
        return p;
    }

    private void merge(Properties p, Iterable<Map.Entry<String, String>> entrySet) {
        for (Map.Entry<String, String> e : entrySet) {
            p.setProperty(e.getKey(), e.getValue());
        }
    }

    protected void logJobDetails(Properties jobConf) {
        for (Map.Entry<Object, Object> e : jobConf.entrySet()) {
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("\n" + e.getKey().toString() + " : " + e.getValue().toString()));
        }
    }
}

